/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.service;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.request.internal.AuthenticateRequest;
import com.ca.mas.core.security.SecureLockException;
import com.ca.mas.core.service.MssoActiveQueue;
import com.ca.mas.core.service.MssoRequest;
import com.ca.mas.core.service.MssoRequestQueue;
import com.ca.mas.core.service.MssoResponse;
import com.ca.mas.core.service.MssoResponseQueue;
import com.ca.mas.core.service.MssoService;
import com.ca.mas.core.service.MssoState;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.util.Functions;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASAuthCredentialsAuthorizationCode;
import com.ca.mas.foundation.MASAuthCredentialsJWT;
import com.ca.mas.foundation.MASAuthCredentialsPassword;

public class MssoClient {
    private final Context appContext;
    private final MssoContext mssoContext;

    public MssoClient(MssoContext mssoContext, Context sysContext) {
        if (sysContext == null) {
            throw new NullPointerException("sysContext");
        }
        if (mssoContext == null) {
            throw new NullPointerException("mssoContext");
        }
        this.mssoContext = mssoContext;
        this.appContext = sysContext.getApplicationContext();
    }

    public long processRequest(MAGRequest request, ResultReceiver resultReceiver) {
        MssoRequest mssoRequest = new MssoRequest(this, this.mssoContext, request, resultReceiver);
        MssoRequestQueue.getInstance().addRequest(mssoRequest);
        long requestId = mssoRequest.getId();
        Context context = this.appContext;
        Intent intent = new Intent("com.ca.mas.core.service.action.PROCESS_REQUEST", null, context, MssoService.class);
        intent.putExtra("com.ca.mas.core.service.req.extra.requestId", requestId);
        context.startService(intent);
        return requestId;
    }

    private Intent createAuthenticationIntent(MASAuthCredentials credentials, MAGResultReceiver resultReceiver) {
        MssoRequest mssoRequest = new MssoRequest(this, this.mssoContext, new AuthenticateRequest(), resultReceiver);
        MssoRequestQueue.getInstance().addRequest(mssoRequest);
        long requestId = mssoRequest.getId();
        Intent intent = new Intent("com.ca.mas.core.service.action.CREDENTIALS_OBTAINED", null, this.appContext, MssoService.class);
        intent.putExtra("com.ca.mas.core.service.req.extra.credentials", (Parcelable)credentials);
        intent.putExtra("com.ca.mas.core.service.req.extra.requestId", requestId);
        return intent;
    }

    public void authenticate(String username, char[] password, MAGResultReceiver resultReceiver) {
        if (username == null || password == null) {
            throw new NullPointerException("Username or password cannot be null");
        }
        MASAuthCredentialsPassword credentials = new MASAuthCredentialsPassword(username, password);
        Intent intent = this.createAuthenticationIntent(credentials, resultReceiver);
        new MssoClientLogoutAsyncTask(this.appContext, this.mssoContext, resultReceiver, intent).execute(new Void[]{null});
    }

    public void authenticate(String authCode, String state, MAGResultReceiver resultReceiver) {
        MASAuthCredentialsAuthorizationCode credentials = new MASAuthCredentialsAuthorizationCode(authCode, state);
        Intent intent = this.createAuthenticationIntent(credentials, resultReceiver);
        new MssoClientAuthenticateAsyncTask(this.appContext, this.mssoContext, resultReceiver, intent).execute(new Void[]{null});
    }

    public void authenticate(IdToken idToken, MAGResultReceiver resultReceiver) {
        MASAuthCredentialsJWT credentials = new MASAuthCredentialsJWT(idToken);
        Intent intent = this.createAuthenticationIntent(credentials, resultReceiver);
        new MssoClientAuthenticateAsyncTask(this.appContext, this.mssoContext, resultReceiver, intent).execute(new Void[]{null});
    }

    public void authenticate(MASAuthCredentials credentials, MAGResultReceiver resultReceiver) {
        Intent intent = this.createAuthenticationIntent(credentials, resultReceiver);
        new MssoClientAuthenticateAsyncTask(this.appContext, this.mssoContext, resultReceiver, intent).execute(new Void[]{null});
    }

    public void processPendingRequests() {
        if (MssoState.isExpectedUnlock()) {
            Intent intent = new Intent("com.ca.mas.core.service.action.PROCESS_REQUEST", null, this.appContext, MssoService.class);
            intent.putExtra("com.ca.mas.core.service.req.extra.requestId", -1L);
            this.appContext.startService(intent);
        }
    }

    public static MAGResponse takeMAGResponse(long requestId) {
        return MssoResponseQueue.getInstance().takeResponse(requestId).getHttpResponse();
    }

    public void cancelRequest(long requestId, Bundle data) {
        MssoRequest request = null;
        MssoResponseQueue.getInstance().takeResponse(requestId);
        request = MssoRequestQueue.getInstance().takeRequest(requestId);
        if (request == null) {
            request = MssoActiveQueue.getInstance().takeRequest(requestId);
        }
        if (request != null && request.getResultReceiver() != null) {
            request.getResultReceiver().send(4, data);
        }
    }

    public void cancelAll(Bundle data) {
        MssoRequestQueue.getInstance().removeMatching(new Functions.Unary<Boolean, MssoRequest>(){

            @Override
            public Boolean call(MssoRequest mssoRequest) {
                return mssoRequest.getCreator() == MssoClient.this;
            }
        }, data);
        MssoResponseQueue.getInstance().removeMatching(new Functions.Unary<Boolean, MssoResponse>(){

            @Override
            public Boolean call(MssoResponse mssoResponse) {
                return mssoResponse.getRequest().getCreator() == MssoClient.this;
            }
        }, data);
        MssoActiveQueue.getInstance().removeMatching(new Functions.Unary<Boolean, MssoRequest>(){

            @Override
            public Boolean call(MssoRequest mssoRequest) {
                return mssoRequest.getCreator() == MssoClient.this;
            }
        }, data);
    }

    private static class MssoClientAuthenticateAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private Context aAppContext;
        private MAGResultReceiver aResultReceiver;
        private Intent aIntent;
        private MssoContext aMssoContext;

        MssoClientAuthenticateAsyncTask(Context context, MssoContext mssoContext, MAGResultReceiver resultReceiver, Intent intent) {
            this.aAppContext = context;
            this.aResultReceiver = resultReceiver;
            this.aMssoContext = mssoContext;
            this.aIntent = intent;
        }

        protected Void doInBackground(Void ... params) {
            block4: {
                try {
                    this.aMssoContext.logout(true);
                }
                catch (SecureLockException e) {
                    if (this.aResultReceiver != null) {
                        this.aResultReceiver.onError(new MAGError(e));
                    }
                }
                catch (Exception ignore) {
                    if (!MAS.DEBUG) break block4;
                    Log.w((String)MAS.TAG, (Throwable)ignore);
                }
            }
            this.aAppContext.startService(this.aIntent);
            return null;
        }
    }

    private static class MssoClientLogoutAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private Context appContext;
        private MAGResultReceiver aResultReceiver;
        private Intent aIntent;
        private MssoContext aMssoContext;

        MssoClientLogoutAsyncTask(Context context, MssoContext mssoContext, MAGResultReceiver resultReceiver, Intent intent) {
            this.appContext = context;
            this.aResultReceiver = resultReceiver;
            this.aMssoContext = mssoContext;
            this.aIntent = intent;
        }

        protected Void doInBackground(Void ... params) {
            block4: {
                try {
                    this.aMssoContext.logout(true);
                }
                catch (SecureLockException e) {
                    if (this.aResultReceiver != null) {
                        this.aResultReceiver.onError(new MAGError(e));
                    }
                }
                catch (Exception ignore) {
                    if (!MAS.DEBUG) break block4;
                    Log.w((String)MAS.TAG, (Throwable)ignore);
                }
            }
            Context context = this.appContext;
            context.startService(this.aIntent);
            return null;
        }
    }
}

