/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.service;

import android.os.Bundle;
import com.ca.mas.core.service.MssoRequest;
import com.ca.mas.core.util.Functions;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class MssoActiveQueue {
    private static final MssoActiveQueue INSTANCE = new MssoActiveQueue();
    private final Map<Long, MssoRequest> activeRequests = Collections.synchronizedMap(new LinkedHashMap());

    private MssoActiveQueue() {
    }

    public static MssoActiveQueue getInstance() {
        return INSTANCE;
    }

    Collection<MssoRequest> getAllRequest() {
        return this.activeRequests.values();
    }

    void addRequest(MssoRequest request) {
        this.activeRequests.put(request.getId(), request);
    }

    MssoRequest getRequest(long requestId) {
        return this.activeRequests.get(requestId);
    }

    MssoRequest takeRequest(long requestId) {
        return this.activeRequests.remove(requestId);
    }

    synchronized void removeMatching(Functions.Unary<Boolean, MssoRequest> predicate, Bundle data) {
        Iterator<MssoRequest> it = this.activeRequests.values().iterator();
        while (it.hasNext()) {
            MssoRequest mssoRequest = it.next();
            if (!predicate.call(mssoRequest).booleanValue()) continue;
            if (mssoRequest.getResultReceiver() != null) {
                mssoRequest.getResultReceiver().send(4, data);
            }
            it.remove();
        }
    }
}

