/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.util.Log;
import com.ca.mas.core.security.KeyStore;
import com.ca.mas.foundation.MAS;
import java.lang.reflect.Method;

public class KeyStoreAdapter
implements KeyStore {
    private static KeyStoreAdapter sInstance = null;
    private Object mAndroidKeyStore;
    private Method mContains;
    private Method mDelete;
    private Method mPut;
    private Method mGet;
    private Method mGetLastError;
    private Method mList;
    private Method mState;
    private Object[] mStateEnumConstants;

    private KeyStoreAdapter() {
        try {
            Class<?> smClass = Class.forName("android.security.KeyStore");
            Method getInstance = smClass.getMethod("getInstance", new Class[0]);
            this.mStateEnumConstants = Class.forName("android.security.KeyStore$State").getEnumConstants();
            this.mState = smClass.getMethod("state", new Class[0]);
            this.mContains = smClass.getMethod("contains", String.class);
            this.mDelete = smClass.getMethod("delete", String.class);
            try {
                this.mPut = smClass.getMethod("put", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.mPut = smClass.getMethod("put", String.class, byte[].class);
            }
            this.mGet = smClass.getMethod("get", String.class);
            this.mGetLastError = smClass.getMethod("getLastError", new Class[0]);
            try {
                this.mList = smClass.getMethod("list", String.class);
            }
            catch (NoSuchMethodException e) {
                this.mList = smClass.getMethod("saw", String.class);
            }
            this.mAndroidKeyStore = getInstance.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.w((String)MAS.TAG, (String)"Unable to create adapter for KeyStore access ", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    public static synchronized KeyStore getKeyStore() {
        if (sInstance == null) {
            sInstance = new KeyStoreAdapter();
        }
        return sInstance;
    }

    @Override
    public boolean isUnlocked() {
        try {
            return this.mState.invoke(this.mAndroidKeyStore, new Object[0]) == this.mStateEnumConstants[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean contains(String key) {
        try {
            return (Boolean)this.mContains.invoke(this.mAndroidKeyStore, key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(String key) {
        try {
            return (Boolean)this.mDelete.invoke(this.mAndroidKeyStore, key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean put(String key, byte[] value) {
        try {
            if (this.mPut.getParameterTypes().length != 2) {
                return (Boolean)this.mPut.invoke(this.mAndroidKeyStore, key, value, -1, 1);
            }
            return (Boolean)this.mPut.invoke(this.mAndroidKeyStore, key, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] get(String key) {
        try {
            return (byte[])this.mGet.invoke(this.mAndroidKeyStore, key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getLastError() {
        try {
            return (Integer)this.mGetLastError.invoke(this.mAndroidKeyStore, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] saw(String prefix) {
        try {
            return (String[])this.mList.invoke(this.mAndroidKeyStore, prefix);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

