/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.registration;

import android.support.annotation.NonNull;
import android.util.Base64;
import android.util.Log;
import com.ca.mas.core.auth.AuthenticationException;
import com.ca.mas.core.cert.CertUtils;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGRequestBody;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.io.Charsets;
import com.ca.mas.core.io.IoUtils;
import com.ca.mas.core.policy.exceptions.InvalidClientCredentialException;
import com.ca.mas.core.registration.RegistrationException;
import com.ca.mas.core.registration.RegistrationServerException;
import com.ca.mas.core.storage.Storage;
import com.ca.mas.core.storage.StorageException;
import com.ca.mas.core.storage.implementation.MASStorageManager;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import java.io.IOException;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

public class RegistrationClient
extends ServerClient {
    private static final int INVALID_CLIENT_CREDENTIALS = 1000201;
    private static final int INVALID_RESOURCE_OWNER_CREDENTIALS = 1000202;
    private Storage mAccountManager;

    public RegistrationClient(MssoContext mssoContext) {
        super(mssoContext);
    }

    public DeviceRegistrationResult registerDevice(@NonNull byte[] certificateSigningRequest, @NonNull MAGRequest request, @NonNull String clientId, @NonNull String clientSecret, @NonNull String deviceId, @NonNull String deviceName, boolean createSession) throws RegistrationException, RegistrationServerException, AuthenticationException, InvalidClientCredentialException {
        X509Certificate[] chain;
        IdToken idToken;
        String magIdentifier;
        DeviceStatus deviceStatus;
        block18: {
            MAGResponse response;
            if (request.getGrantProvider().getCredentials(this.mssoContext) == null) {
                throw new NullPointerException("credentials");
            }
            URI tokenUri = request.getGrantProvider().getRegistrationPath(this.mssoContext);
            if (tokenUri == null) {
                throw new RegistrationException(120004, "No device registration URL is configured");
            }
            MAGRequest.MAGRequestBuilder builder = new MAGRequest.MAGRequestBuilder(tokenUri);
            MASAuthCredentials creds = request.getGrantProvider().getCredentials(this.mssoContext);
            Map<String, List<String>> headers = creds.getHeaders(this.mssoContext);
            if (headers != null) {
                for (String key : headers.keySet()) {
                    if (headers.get(key) == null) continue;
                    for (String value : headers.get(key)) {
                        builder.header(key, value);
                    }
                }
            }
            builder.header("client-authorization", "Basic " + IoUtils.base64(clientId + ":" + clientSecret, Charsets.ASCII));
            builder.header("device-id", IoUtils.base64(deviceId, Charsets.ASCII));
            builder.header("device-name", IoUtils.base64(deviceName, Charsets.ASCII));
            if (request.getGrantProvider().isSessionSupported()) {
                builder.header("create-session", Boolean.toString(createSession));
            }
            builder.header("cert-format", "pem");
            builder.post(MAGRequestBody.byteArrayBody(Base64.encode((byte[])certificateSigningRequest, (int)11)));
            MAGHttpClient httpClient = this.mssoContext.getMAGHttpClient();
            try {
                response = httpClient.execute(builder.build());
            }
            catch (IOException e) {
                throw new RegistrationException(120004, "Unable to post to register_device: " + e.getMessage(), e);
            }
            if (MAS.DEBUG) {
                Log.d((String)MAS.TAG, (String)String.format("%s response with status: %d", request.getURL(), response.getResponseCode()));
            }
            if (response.getResponseCode() != 200) {
                RegistrationServerException e = ServerClient.createServerException(response, RegistrationServerException.class);
                if (e.getErrorCode() == 1000201) {
                    throw new InvalidClientCredentialException(e);
                }
                if (e.getErrorCode() == 1000202) {
                    throw new AuthenticationException(e);
                }
                throw e;
            }
            deviceStatus = RegistrationClient.findDeviceStatus(response);
            magIdentifier = this.findMagIdentifier(response);
            idToken = this.findIdToken(response, createSession && request.getGrantProvider().isSessionSupported());
            MAGResponseBody responseEntity = response.getBody();
            if (responseEntity == null) {
                throw new RegistrationException(120006, "register_device response did not contain an entity");
            }
            byte[] chainBytes = responseEntity.getRawContent();
            if (chainBytes.length < 1) {
                throw new RegistrationException(120006, "register_device response was empty");
            }
            chain = CertUtils.decodeCertificateChain(chainBytes);
            if (chain.length < 1) {
                throw new RegistrationException(120006, "register_device response did not include a certificate chain");
            }
            Storage accountManager = this.getAccountManager();
            if (accountManager != null) {
                try {
                    accountManager.writeData("registration_type", creds.getGrantType().getBytes());
                }
                catch (StorageException e) {
                    if (!MAS.DEBUG) break block18;
                    Log.e((String)MAS.TAG, (String)"Failed to save authentication type: ", (Throwable)e);
                }
            }
        }
        return new DeviceRegistrationResult(){

            @Override
            public DeviceStatus getDeviceStatus() {
                return deviceStatus;
            }

            @Override
            public String getMagIdentifier() {
                return magIdentifier;
            }

            @Override
            public IdToken getIdToken() {
                return idToken;
            }

            @Override
            public X509Certificate[] getClientCertificateChain() {
                return chain;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DeviceStatus findDeviceStatus(MAGResponse response) throws RegistrationException {
        List<String> headers = response.getHeaders().get("device-status");
        if (headers == null) throw new RegistrationException(120006, "register_device response did not include exactly one device status header.");
        if (headers.size() != 1) throw new RegistrationException(120006, "register_device response did not include exactly one device status header.");
        String value = headers.get(0);
        if ("activated".equalsIgnoreCase(value)) {
            return DeviceStatus.ACTIVATED;
        }
        if (!"registered".equalsIgnoreCase(value)) throw new RegistrationException(120006, "register_device response did not include a recognized device status.  Status was: " + value);
        return DeviceStatus.REGISTERED;
    }

    private String findMagIdentifier(MAGResponse response) throws RegistrationException {
        String value;
        List<String> headers = response.getHeaders().get("mag-identifier");
        if (headers != null && headers.size() == 1) {
            value = headers.get(0);
            byte[] decoded = Base64.decode((String)value, (int)0);
            if (decoded == null || decoded.length < 1) {
                throw new RegistrationException(120008, "register_device response did not include a valid mag identifier.");
            }
        } else {
            throw new RegistrationException(120008, "register_device response did not include exactly one mag identifier header.");
        }
        String magIdentifier = value;
        return magIdentifier;
    }

    private IdToken findIdToken(MAGResponse response, boolean require) throws RegistrationException {
        List<String> idTokens = response.getHeaders().get("id-token");
        List<String> idTokenTypes = response.getHeaders().get("id-token-type");
        if (idTokens == null || idTokens.size() != 1 || idTokenTypes == null || idTokenTypes.size() != 1) {
            if (require) {
                throw new RegistrationException(120006, "register_device response did not include exactly one ID token and ID Token type header.");
            }
            return null;
        }
        String idToken = idTokens.get(0);
        if (idToken.trim().length() < 1) {
            throw new RegistrationException(120006, "register_device response did not include a valid ID token.");
        }
        String idTokenType = idTokenTypes.get(0);
        if (idTokenType.trim().length() < 1) {
            throw new RegistrationException(120006, "register_device response did not include a valid ID token type.");
        }
        return new IdToken(idToken, idTokenType);
    }

    public void removeDeviceRegistration() throws RegistrationException, RegistrationServerException {
        MAGResponse response;
        MAGRequest.MAGRequestBuilder builder = new MAGRequest.MAGRequestBuilder(this.conf.getTokenUri("msso.url.remove_device_x509")).delete(null);
        MAGHttpClient httpClient = this.mssoContext.getMAGHttpClient();
        try {
            response = httpClient.execute(builder.build());
        }
        catch (IOException e) {
            throw new RegistrationException(120003, "Unable to de-register device: " + e.getMessage(), e);
        }
        if (200 != response.getResponseCode()) {
            throw ServerClient.createServerException(response, RegistrationServerException.class);
        }
        this.removeAuthCredentialsType();
    }

    private Storage getAccountManager() {
        block3: {
            if (this.mAccountManager == null) {
                try {
                    this.mAccountManager = new MASStorageManager().getStorage(MASStorageManager.MASStorageType.TYPE_AMS, (Object)new Object[]{MAS.getContext(), false});
                }
                catch (StorageException e) {
                    if (!MAS.DEBUG) break block3;
                    Log.e((String)MAS.TAG, (String)"Failed to retrieve account manager: ", (Throwable)e);
                }
            }
        }
        return this.mAccountManager;
    }

    private void removeAuthCredentialsType() {
        block3: {
            Storage accountManager = this.getAccountManager();
            if (accountManager != null) {
                try {
                    accountManager.deleteData("registration_type");
                }
                catch (StorageException e) {
                    if (!MAS.DEBUG) break block3;
                    Log.e((String)MAS.TAG, (String)"Failed to delete authentication type: ", (Throwable)e);
                }
            }
        }
    }

    public static interface DeviceRegistrationResult {
        public DeviceStatus getDeviceStatus();

        public String getMagIdentifier();

        public IdToken getIdToken();

        public X509Certificate[] getClientCertificateChain();
    }

    public static enum DeviceStatus {
        ACTIVATED,
        REGISTERED;

    }
}

