/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.auth.AuthenticationException;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.oauth.GrantProvider;
import com.ca.mas.core.oauth.OAuthException;
import com.ca.mas.core.oauth.OAuthServerException;
import com.ca.mas.core.oauth.OAuthTokenClient;
import com.ca.mas.core.oauth.OAuthTokenResponse;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.exceptions.CredentialRequiredException;
import com.ca.mas.core.policy.exceptions.RetryRequestException;
import com.ca.mas.core.request.MAGInternalRequest;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.token.JWTValidationException;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class AccessTokenAssertion
implements MssoAssertion {
    public static final String TOKEN_EXPIRED_ERROR_CODE_SUFFIX = "990";
    private OAuthTokenClient oAuthTokenClient;

    AccessTokenAssertion() {
    }

    @Override
    public void init(@NonNull MssoContext mssoContext, @NonNull Context sysContext) {
        this.oAuthTokenClient = new OAuthTokenClient(mssoContext);
    }

    @Override
    public synchronized void processRequest(MssoContext mssoContext, RequestInfo request) throws MAGException, MAGServerException {
        if (request.getRequest().getURL() != null && request.getRequest().getURL().getHost() == null) {
            throw new IllegalArgumentException("Host is not provided");
        }
        MAGInternalRequest magInternalRequest = request.getRequest();
        String accessToken = this.findAccessToken(mssoContext, magInternalRequest);
        if (accessToken != null) {
            request.getRequest().addHeader("Authorization", "Bearer " + accessToken);
        }
    }

    @Override
    public void processResponse(MssoContext mssoContext, RequestInfo request, MAGResponse response) throws MAGException {
        int errorCode = ServerClient.findErrorCode(response);
        if (errorCode == -1) {
            return;
        }
        String s = Integer.toString(errorCode);
        if (s.endsWith(TOKEN_EXPIRED_ERROR_CODE_SUFFIX)) {
            throw new RetryRequestException("Access token rejected by server"){

                @Override
                public void recover(MssoContext context) throws Exception {
                    context.clearAccessToken();
                }
            };
        }
    }

    @Override
    public void close() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findAccessToken(MssoContext mssoContext, MAGInternalRequest request) throws CredentialRequiredException, OAuthException, OAuthServerException, AuthenticationException, JWTValidationException, RetryRequestException {
        IdToken idToken;
        String accessToken = mssoContext.getAccessToken();
        if (accessToken != null) {
            block15: {
                if (MAS.DEBUG) {
                    Log.d((String)MAS.TAG, (String)"Validating access token");
                }
                if (this.isAccessTokenStillValid(mssoContext)) {
                    if (MAS.DEBUG) {
                        Log.d((String)MAS.TAG, (String)"Access Token is still valid.");
                    }
                    if (this.isSufficientScope(mssoContext, request)) {
                        if (request.getGrantProvider() != GrantProvider.PASSWORD) return accessToken;
                        if (mssoContext.getRefreshToken() != null) return accessToken;
                        mssoContext.clearAccessToken();
                        accessToken = null;
                    } else {
                        if (MAS.DEBUG) {
                            Log.d((String)MAS.TAG, (String)"Access Token does not have sufficient scope.");
                        }
                        mssoContext.clearAccessToken();
                        accessToken = null;
                    }
                } else {
                    accessToken = null;
                }
                String refreshToken = mssoContext.getRefreshToken();
                if (refreshToken != null) {
                    try {
                        if (MAS.DEBUG) {
                            Log.d((String)MAS.TAG, (String)"Obtain Access Token using Refresh Token");
                        }
                        accessToken = this.obtainAccessTokenUsingRefreshToken(mssoContext, refreshToken);
                    }
                    catch (OAuthServerException tse) {
                        mssoContext.clearAccessToken();
                        accessToken = null;
                        if (!MAS.DEBUG) break block15;
                        Log.w((String)MAS.TAG, (String)("Refresh token failed, will fall back to ID token or password: " + tse.getMessage()), (Throwable)tse);
                    }
                }
            }
            if (accessToken != null) {
                return accessToken;
            }
        }
        if (this.oAuthTokenClient == null) {
            throw new IllegalStateException("policy not initialized");
        }
        boolean ssoEnabled = (Boolean)mssoContext.getConfigurationProvider().getProperty("msso.sso.enabled");
        if (ssoEnabled && (idToken = mssoContext.getIdToken()) != null) {
            if (!MAS.DEBUG) return this.obtainAccessTokenUsingIdToken(mssoContext, idToken, request);
            Log.d((String)MAS.TAG, (String)"Try to use id token to get new Access Token");
            return this.obtainAccessTokenUsingIdToken(mssoContext, idToken, request);
        }
        if (!MAS.DEBUG) return this.obtainAccessTokenUsingCredential(mssoContext, request, ssoEnabled);
        Log.d((String)MAS.TAG, (String)"Obtain access token using Credential");
        return this.obtainAccessTokenUsingCredential(mssoContext, request, ssoEnabled);
    }

    private boolean isAccessTokenStillValid(MssoContext mssoContext) {
        long expiry = mssoContext.getAccessTokenExpiry();
        return expiry <= 0L || System.currentTimeMillis() <= expiry;
    }

    private boolean isSufficientScope(MssoContext mssoContext, MAGRequest request) {
        String rScope = request.getScope();
        String gScope = mssoContext.getGrantedScope();
        if (rScope == null || rScope.trim().length() == 0) {
            return true;
        }
        if (gScope == null || gScope.trim().length() == 0) {
            return false;
        }
        String[] requestScopes = rScope.trim().split("\\s+");
        ArrayList rScopeList = new ArrayList();
        Collections.addAll(rScopeList, requestScopes);
        rScopeList.remove("openid");
        rScopeList.remove("msso");
        rScopeList.remove("msso_register");
        rScopeList.remove("msso_client_register");
        String[] grantedScopes = gScope.split("\\s+");
        List<String> gScopeList = Arrays.asList(grantedScopes);
        return gScopeList.containsAll(rScopeList);
    }

    private static MASAuthCredentials getCredsOrThrow(MssoContext mssoContext, MAGInternalRequest request) throws CredentialRequiredException {
        MASAuthCredentials creds = request.getGrantProvider().getCredentials(mssoContext);
        if (creds == null || !creds.isValid()) {
            throw new CredentialRequiredException();
        }
        return creds;
    }

    private String obtainAccessTokenUsingIdToken(MssoContext mssoContext, IdToken idToken, MAGInternalRequest request) throws CredentialRequiredException, OAuthException, AuthenticationException, JWTValidationException, OAuthServerException, RetryRequestException {
        String clientId = mssoContext.getClientId();
        String clientSecret = mssoContext.getClientSecret();
        String scope = request.getScope();
        try {
            OAuthTokenResponse response = this.oAuthTokenClient.obtainAccessTokenUsingIdToken(idToken, clientId, clientSecret, scope);
            String accessToken = response.getAccessToken();
            mssoContext.onAccessTokenAvailable(accessToken, response.getRefreshToken(), response.getExpiresIn(), response.getGrantedScope());
            return accessToken;
        }
        catch (OAuthServerException e) {
            mssoContext.clearIdToken();
            mssoContext.clearUserProfile();
            return this.obtainAccessTokenUsingCredential(mssoContext, request, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String obtainAccessTokenUsingCredential(MssoContext mssoContext, MAGInternalRequest request, boolean wantIdToken) throws CredentialRequiredException, AuthenticationException, OAuthServerException, OAuthException, JWTValidationException {
        mssoContext.clearUserProfile();
        AccessTokenAssertion.getCredsOrThrow(mssoContext, request);
        String clientId = mssoContext.getClientId();
        String clientSecret = mssoContext.getClientSecret();
        boolean gotToken = false;
        try {
            OAuthTokenResponse response = this.oAuthTokenClient.obtainTokensUsingCredentials(request, clientId, clientSecret, wantIdToken);
            IdToken idToken = response.getIdToken();
            if (idToken != null) {
                mssoContext.onIdTokenAvailable(idToken);
            }
            String accessToken = response.getAccessToken();
            mssoContext.onAccessTokenAvailable(accessToken, response.getRefreshToken(), response.getExpiresIn(), response.getGrantedScope());
            gotToken = accessToken != null;
            String string = accessToken;
            return string;
        }
        finally {
            if (!gotToken || !request.getGrantProvider().getCredentials(mssoContext).isReusable()) {
                mssoContext.setCredentials(null);
            }
        }
    }

    private String obtainAccessTokenUsingRefreshToken(MssoContext mssoContext, String refreshToken) throws OAuthException, OAuthServerException, AuthenticationException, RetryRequestException {
        String clientId = mssoContext.getClientId();
        String clientSecret = mssoContext.getClientSecret();
        OAuthTokenResponse response = this.oAuthTokenClient.obtainTokenUsingRefreshToken(refreshToken, clientId, clientSecret);
        String accessToken = response.getAccessToken();
        mssoContext.onAccessTokenAvailable(accessToken, response.getRefreshToken(), response.getExpiresIn(), response.getGrantedScope());
        return accessToken;
    }
}

