/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.http;

import android.net.Uri;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.http.MAGRequestBody;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.oauth.GrantProvider;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASSecurityConfiguration;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface MAGRequest {
    public URL getURL();

    public String getMethod();

    public Map<String, List<String>> getHeaders();

    public GrantProvider getGrantProvider();

    public MAGRequestBody getBody();

    public MAGConnectionListener getConnectionListener();

    public MAGResponseBody<?> getResponseBody();

    public String getScope();

    public boolean isPublic();

    public static class MAGRequestBuilder {
        private URL url;
        private String method = Method.GET.name();
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private MAGRequestBody body;
        private MAGResponseBody<?> responseBody = new MAGResponseBody();
        private GrantProvider grantProvider = ConfigurationManager.getInstance().getDefaultGrantProvider();
        private String scope;
        private MAGConnectionListener listener;
        private boolean isPublic;
        private boolean sign;
        private long timeout;
        private TimeUnit timeUnit;

        public MAGRequestBuilder(URI uri) {
            try {
                if (uri != null) {
                    this.url = uri.toURL();
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public MAGRequestBuilder(Uri uri) {
            try {
                if (uri != null) {
                    this.url = new URL(uri.toString());
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public MAGRequestBuilder(MAGRequest request) {
            this.method = request.getMethod();
            this.body = request.getBody();
            this.grantProvider = request.getGrantProvider();
            this.scope = request.getScope();
            this.responseBody = request.getResponseBody();
            this.isPublic = request.isPublic();
            this.headers = request.getHeaders();
            this.listener = request.getConnectionListener();
        }

        public MAGRequestBuilder(URL url) {
            this.url = url;
        }

        public MAGRequestBuilder get() {
            this.method = Method.GET.name();
            this.body = null;
            return this;
        }

        public MAGRequestBuilder post(MAGRequestBody body) {
            this.method = Method.POST.name();
            this.body = body;
            return this;
        }

        public MAGRequestBuilder put(MAGRequestBody body) {
            this.method = Method.PUT.name();
            this.body = body;
            return this;
        }

        public MAGRequestBuilder delete(MAGRequestBody body) {
            this.method = Method.DELETE.name();
            this.body = body;
            return this;
        }

        public MAGRequestBuilder password() {
            this.grantProvider = GrantProvider.PASSWORD;
            return this;
        }

        public MAGRequestBuilder clientCredential() {
            this.grantProvider = GrantProvider.CLIENT_CREDENTIALS;
            return this;
        }

        public MAGRequestBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public MAGRequestBuilder responseBody(MAGResponseBody responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public MAGRequestBuilder setPublic() {
            this.isPublic = true;
            return this;
        }

        public MAGRequestBuilder header(String name, String value) {
            List<String> values = this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
            return this;
        }

        public MAGRequestBuilder removeHeader(String name) {
            this.headers.remove(name);
            return this;
        }

        public MAGRequestBuilder connectionListener(MAGConnectionListener listener) {
            this.listener = listener;
            return this;
        }

        public MAGRequest build() {
            HashMap newHeaders = new HashMap();
            for (String key : this.headers.keySet()) {
                ArrayList<String> headerValues = new ArrayList<String>();
                if (this.headers.get(key) != null) {
                    for (String value : this.headers.get(key)) {
                        headerValues.add(value);
                    }
                }
                newHeaders.put(key, Collections.unmodifiableList(headerValues));
            }
            final Map unmodifiableHeaders = Collections.unmodifiableMap(newHeaders);
            if (!this.isPublic && this.url != null) {
                Uri uri = Uri.parse((String)this.url.toString());
                MASSecurityConfiguration config = MASConfiguration.getCurrentConfiguration().getSecurityConfiguration(uri);
                if (config != null && config.isPublic()) {
                    this.setPublic();
                }
            }
            return new MAGRequest(){

                @Override
                public URL getURL() {
                    return MAGRequestBuilder.this.url;
                }

                @Override
                public String getMethod() {
                    return MAGRequestBuilder.this.method;
                }

                @Override
                public Map<String, List<String>> getHeaders() {
                    return unmodifiableHeaders;
                }

                @Override
                public GrantProvider getGrantProvider() {
                    return MAGRequestBuilder.this.grantProvider;
                }

                @Override
                public MAGRequestBody getBody() {
                    return MAGRequestBuilder.this.body;
                }

                @Override
                public MAGConnectionListener getConnectionListener() {
                    return MAGRequestBuilder.this.listener;
                }

                public MAGResponseBody getResponseBody() {
                    return MAGRequestBuilder.this.responseBody;
                }

                @Override
                public String getScope() {
                    return MAGRequestBuilder.this.scope;
                }

                @Override
                public boolean isPublic() {
                    return MAGRequestBuilder.this.isPublic;
                }
            };
        }
    }

    public static interface MAGConnectionListener {
        public void onObtained(HttpURLConnection var1);

        public void onConnected(HttpURLConnection var1);
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

