/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.context;

import android.content.Context;
import com.ca.mas.core.io.IoUtils;
import com.ca.mas.core.util.KeyUtilsAsymmetric;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

public abstract class UniqueIdentifier {
    protected String identifier = "";
    private static String identifierKey;

    public UniqueIdentifier(Context context) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException {
        identifierKey = this.getIdentifierKey();
        PublicKey publicKey = KeyUtilsAsymmetric.getRsaPublicKey(identifierKey);
        if (publicKey == null) {
            KeyUtilsAsymmetric.generateRsaPrivateKey(context, 2048, identifierKey, String.format("CN=%s, OU=%s", identifierKey, "com.ca"), false, false, Integer.MAX_VALUE, false);
            publicKey = KeyUtilsAsymmetric.getRsaPublicKey(identifierKey);
        }
        byte[] encoded = publicKey.getEncoded();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(encoded);
        byte[] mdBytes = md.digest();
        this.identifier = IoUtils.hexDump(mdBytes);
    }

    public String toString() {
        return this.identifier;
    }

    protected abstract String getIdentifierKey();
}

