/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.clientcredentials;

import android.support.annotation.NonNull;
import android.util.Pair;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.clientcredentials.ClientCredentialsException;
import com.ca.mas.core.clientcredentials.ClientCredentialsServerException;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGRequestBody;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.io.Charsets;
import com.ca.mas.core.io.IoUtils;
import com.ca.mas.core.token.ClientCredentials;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientCredentialsClient
extends ServerClient {
    public ClientCredentialsClient(MssoContext mssoContext) {
        super(mssoContext);
    }

    public ClientCredentials getClientCredentials(@NonNull String masterClientId, String nonce, @NonNull String deviceId) throws ClientCredentialsException, ClientCredentialsServerException {
        MAGResponse response;
        URI tokenUri = this.conf.getTokenUri("msso.url.client_credentials");
        MAGRequest request = null;
        try {
            ArrayList<Pair> form = new ArrayList<Pair>();
            form.add(new Pair((Object)"client_id", (Object)masterClientId));
            form.add(new Pair((Object)"nonce", (Object)nonce));
            request = new MAGRequest.MAGRequestBuilder(tokenUri.toURL()).header("device-id", IoUtils.base64(deviceId, Charsets.ASCII)).post(MAGRequestBody.urlEncodedFormBody(form)).responseBody(MAGResponseBody.jsonBody()).build();
        }
        catch (MalformedURLException e) {
            throw new ClientCredentialsException(110002, "Unable to set post for client credentials: " + e.getMessage(), e);
        }
        MAGHttpClient httpClient = this.mssoContext.getMAGHttpClient();
        try {
            response = httpClient.execute(request);
        }
        catch (IOException e) {
            throw new ClientCredentialsException(110002, "Unable to post to register_device: " + e.getMessage(), e);
        }
        try {
            int statusCode = response.getResponseCode();
            if (statusCode != 200) {
                throw ServerClient.createServerException(response, ClientCredentialsServerException.class);
            }
            JSONObject jsonObject = (JSONObject)response.getBody().getContent();
            String slaveClientId = jsonObject.getString("client_id");
            String slaveClientSecret = jsonObject.getString("client_secret");
            Long slaveClientExpiration = jsonObject.getLong("client_expiration");
            return new ClientCredentials(masterClientId, slaveClientId, slaveClientSecret, slaveClientExpiration);
        }
        catch (JSONException e) {
            throw new ClientCredentialsException(110002, (Throwable)e);
        }
    }
}

