/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.auth.otp;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.MobileSso;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.service.MssoService;
import java.net.URI;
import java.util.List;

public class OtpAuthenticationHandler
implements Parcelable {
    private long requestId;
    private List<String> channels;
    private boolean isInvalidOtp;
    private String selectedChannels;
    public static final Parcelable.Creator<OtpAuthenticationHandler> CREATOR = new Parcelable.Creator<OtpAuthenticationHandler>(){

        public OtpAuthenticationHandler createFromParcel(Parcel source) {
            return new OtpAuthenticationHandler(source);
        }

        public OtpAuthenticationHandler[] newArray(int size) {
            return new OtpAuthenticationHandler[size];
        }
    };

    public OtpAuthenticationHandler(long requestId, List<String> channels, boolean isInvalidOtp, String selectedChannels) {
        this.requestId = requestId;
        this.channels = channels;
        this.isInvalidOtp = isInvalidOtp;
        this.selectedChannels = selectedChannels;
    }

    public void proceed(Context context, String otp) {
        Intent intent = new Intent("com.ca.mas.core.service.action.VALIDATE_OTP", null, context, MssoService.class);
        intent.putExtra("com.ca.mas.core.service.req.extra.requestId", this.requestId);
        intent.putExtra("com.ca.mas.core.service.req.extra.auth.otp.value", otp);
        intent.putExtra("com.ca.mas.core.service.req.extra.auth.otp.channels", this.selectedChannels);
        context.startService(intent);
    }

    public void deliver(String channels, MAGResultReceiver<Void> callback) {
        this.selectedChannels = channels;
        MobileSso mobileSso = MobileSsoFactory.getInstance();
        String otpAuthUrl = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.url.auth_otp");
        URI otpDeliveryUrl = mobileSso.getURI(otpAuthUrl);
        MAGRequest request = new MAGRequest.MAGRequestBuilder(otpDeliveryUrl).header("X-OTP-CHANNEL", channels).build();
        mobileSso.processRequest(request, callback);
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public boolean isInvalidOtp() {
        return this.isInvalidOtp;
    }

    public void cancel() {
        MobileSsoFactory.getInstance().cancelRequest(this.requestId, null);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.requestId);
        dest.writeStringList(this.channels);
        dest.writeByte(this.isInvalidOtp ? (byte)1 : 0);
        dest.writeString(this.selectedChannels);
    }

    protected OtpAuthenticationHandler(Parcel in) {
        this.requestId = in.readLong();
        this.channels = in.createStringArrayList();
        this.isInvalidOtp = in.readByte() != 0;
        this.selectedChannels = in.readString();
    }
}

