/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.auth;

import android.graphics.Bitmap;
import android.view.View;
import com.ca.mas.core.auth.PollingRenderer;
import com.ca.mas.core.auth.QRCode;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;

public class QRCodeRenderer
extends PollingRenderer {
    public static final int QRCODE_ERROR = 100;
    private static final int HEIGHT = 250;
    private static final int WIDTH = 250;

    private Bitmap toBitmap(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                pixels[offset + x] = matrix.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    @Override
    public View render() {
        QRCodeWriter writer = new QRCodeWriter();
        QRCode imageView = new QRCode(this.context);
        try {
            BitMatrix matrix = writer.encode(this.provider.getUrl(), BarcodeFormat.QR_CODE, this.getQRCodeWidth(), this.getQRCodeHeight());
            Bitmap bmp = this.toBitmap(matrix);
            imageView.setImageBitmap(bmp);
            imageView.setContentDescription(this.provider.getId());
            return imageView;
        }
        catch (WriterException e) {
            this.onError(100, e.getMessage(), (Exception)((Object)e));
            return null;
        }
    }

    @Override
    public void onError(int code, String m, Exception e) {
    }

    protected int getQRCodeWidth() {
        return 250;
    }

    protected int getQRCodeHeight() {
        return 250;
    }

    @Override
    protected boolean startPollingOnStartup() {
        return true;
    }
}

