/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.user;

import android.support.annotation.NonNull;
import com.ca.mas.foundation.MASTransformable;
import org.json.JSONException;
import org.json.JSONObject;

public class MASAddress
implements MASTransformable {
    private String mFormattedAddr;
    private String mAddrType;
    private String mStreetAddr;
    private String mLocality;
    private String mRegion;
    private String mPostalCode;
    private String mCountry;
    private boolean mIsPrimary;

    public MASAddress() {
    }

    public MASAddress(String streetAddr, String locality, String region, String country, String postalCode) {
        this.mStreetAddr = streetAddr;
        this.mLocality = locality;
        this.mRegion = region;
        this.mCountry = country;
        this.mPostalCode = postalCode;
    }

    @Override
    public void populate(@NonNull JSONObject addrObj) throws JSONException {
        this.mFormattedAddr = addrObj.optString("formatted");
        this.mAddrType = addrObj.optString("type");
        this.mStreetAddr = addrObj.optString("streetAddress");
        this.mLocality = addrObj.optString("locality");
        this.mRegion = addrObj.optString("region");
        this.mPostalCode = addrObj.optString("postalCode");
        this.mCountry = addrObj.optString("country");
        this.mIsPrimary = addrObj.optBoolean("primary");
    }

    @Override
    public JSONObject getAsJSONObject() throws JSONException {
        JSONObject jobj = new JSONObject();
        jobj.put("formatted", (Object)this.mFormattedAddr);
        jobj.put("type", (Object)this.mAddrType);
        jobj.put("streetAddress", (Object)this.mStreetAddr);
        jobj.put("locality", (Object)this.mLocality);
        jobj.put("region", (Object)this.mRegion);
        jobj.put("postalCode", (Object)this.mPostalCode);
        jobj.put("country", (Object)this.mCountry);
        jobj.put("primary", this.mIsPrimary);
        return jobj;
    }

    public void setCountry(String country) {
        this.mCountry = country;
    }

    public String getLocality() {
        return this.mLocality;
    }

    public String getFormatted() {
        return this.mFormattedAddr;
    }

    public String getType() {
        return this.mAddrType;
    }

    public String getStreetAddress() {
        return this.mStreetAddr;
    }

    public String getRegion() {
        return this.mRegion;
    }

    public String getPostalCode() {
        return this.mPostalCode;
    }

    public String getCountry() {
        return this.mCountry;
    }

    public boolean isPrimary() {
        return this.mIsPrimary;
    }
}

