/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.net.Uri;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGRequestBody;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.oauth.GrantProvider;
import com.ca.mas.core.request.internal.LocalRequest;
import com.ca.mas.foundation.MASRequest;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MASTokenRequest
implements MASRequest,
LocalRequest {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String EXPIRES_IN = "expires_in";
    private MASRequest request;

    public MASTokenRequest() {
        this.request = new MASRequest.MASRequestBuilder(new Uri.Builder().appendPath("token").build()).build();
    }

    public MASTokenRequest(MASRequest request) {
        this.request = request;
    }

    @Override
    public MAGResponse send(final MssoContext context) throws IOException {
        return new MAGResponse<JSONObject>(){

            @Override
            public Map<String, List<String>> getHeaders() {
                return null;
            }

            @Override
            public int getResponseCode() {
                return 200;
            }

            @Override
            public String getResponseMessage() {
                return null;
            }

            @Override
            public MAGResponseBody<JSONObject> getBody() {
                return new MAGResponseBody<JSONObject>(){

                    @Override
                    public JSONObject getContent() {
                        JSONObject entity = new JSONObject();
                        try {
                            entity.put(MASTokenRequest.ACCESS_TOKEN, (Object)context.getAccessToken());
                            entity.put(MASTokenRequest.REFRESH_TOKEN, (Object)context.getRefreshToken());
                            entity.put(MASTokenRequest.EXPIRES_IN, context.getAccessTokenExpiry());
                        }
                        catch (JSONException e) {
                            return new JSONObject();
                        }
                        return entity;
                    }
                };
            }
        };
    }

    @Override
    public URL getURL() {
        return this.request.getURL();
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.request.getHeaders();
    }

    @Override
    public GrantProvider getGrantProvider() {
        return this.request.getGrantProvider();
    }

    @Override
    public MAGRequestBody getBody() {
        return this.request.getBody();
    }

    @Override
    public MAGRequest.MAGConnectionListener getConnectionListener() {
        return this.request.getConnectionListener();
    }

    @Override
    public MAGResponseBody<?> getResponseBody() {
        return this.request.getResponseBody();
    }

    @Override
    public String getScope() {
        return this.request.getScope();
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean notifyOnCancel() {
        return false;
    }
}

