/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.net.Uri;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGRequestBody;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.oauth.GrantProvider;
import com.ca.mas.foundation.MASClaims;
import com.ca.mas.foundation.MASRequestBody;
import java.net.URI;
import java.net.URL;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;

public interface MASRequest
extends MAGRequest {
    public boolean notifyOnCancel();

    public static class MASRequestBuilder
    extends MAGRequest.MAGRequestBuilder {
        private boolean notifyOnCancel = false;
        private boolean sign = false;
        private MASClaims claim;
        private PrivateKey privateKey;

        public MASRequestBuilder(URI uri) {
            super(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUri(uri.toString()));
        }

        public MASRequestBuilder(Uri uri) {
            super(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUri(uri.toString()));
        }

        public MASRequestBuilder(URL url) {
            super(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUri(url.toString()));
        }

        @Override
        public MASRequestBuilder get() {
            return (MASRequestBuilder)super.get();
        }

        public MASRequestBuilder post(MASRequestBody body) {
            return (MASRequestBuilder)super.post(body);
        }

        public MASRequestBuilder put(MASRequestBody body) {
            return (MASRequestBuilder)super.put(body);
        }

        public MASRequestBuilder delete(MASRequestBody body) {
            return (MASRequestBuilder)super.delete(body);
        }

        @Override
        public MASRequestBuilder password() {
            return (MASRequestBuilder)super.password();
        }

        @Override
        public MASRequestBuilder clientCredential() {
            return (MASRequestBuilder)super.clientCredential();
        }

        @Override
        public MASRequestBuilder scope(String scope) {
            return (MASRequestBuilder)super.scope(scope);
        }

        @Override
        public MASRequestBuilder responseBody(MAGResponseBody responseBody) {
            return (MASRequestBuilder)super.responseBody(responseBody);
        }

        @Override
        public MASRequestBuilder setPublic() {
            return (MASRequestBuilder)super.setPublic();
        }

        @Override
        public MASRequestBuilder header(String name, String value) {
            return (MASRequestBuilder)super.header(name, value);
        }

        @Override
        public MASRequestBuilder removeHeader(String name) {
            return (MASRequestBuilder)super.removeHeader(name);
        }

        @Override
        public MASRequestBuilder connectionListener(MAGRequest.MAGConnectionListener listener) {
            return (MASRequestBuilder)super.connectionListener(listener);
        }

        public MASRequestBuilder notifyOnCancel() {
            this.notifyOnCancel = true;
            return this;
        }

        public MASRequestBuilder sign() {
            this.sign = true;
            return this;
        }

        public MASRequestBuilder sign(MASClaims claim) {
            this.sign = true;
            this.claim = claim;
            return this;
        }

        public MASRequestBuilder sign(PrivateKey privateKey) {
            this.sign = true;
            this.privateKey = privateKey;
            return this;
        }

        @Override
        public MASRequest build() {
            final MAGRequest request = super.build();
            return new MASRequest(){

                @Override
                public boolean notifyOnCancel() {
                    return MASRequestBuilder.this.notifyOnCancel;
                }

                @Override
                public URL getURL() {
                    return request.getURL();
                }

                @Override
                public String getMethod() {
                    return request.getMethod();
                }

                @Override
                public Map<String, List<String>> getHeaders() {
                    return request.getHeaders();
                }

                @Override
                public GrantProvider getGrantProvider() {
                    return request.getGrantProvider();
                }

                @Override
                public MAGRequestBody getBody() {
                    if (MASRequestBuilder.this.sign && request.getBody() != null) {
                        return MASRequestBody.jwtClaimsBody(MASRequestBuilder.this.claim, MASRequestBuilder.this.privateKey, request.getBody());
                    }
                    return request.getBody();
                }

                @Override
                public MAGRequest.MAGConnectionListener getConnectionListener() {
                    return request.getConnectionListener();
                }

                @Override
                public MAGResponseBody<?> getResponseBody() {
                    return request.getResponseBody();
                }

                @Override
                public String getScope() {
                    return request.getScope();
                }

                @Override
                public boolean isPublic() {
                    return request.isPublic();
                }
            };
        }
    }
}

