/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.app.Activity;
import android.app.Application;
import android.content.AsyncTaskLoader;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.EventDispatcher;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.MobileSsoListener;
import com.ca.mas.core.auth.otp.OtpAuthenticationHandler;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.oauth.GrantProvider;
import com.ca.mas.core.service.AuthenticationProvider;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.foundation.Internal;
import com.ca.mas.foundation.MASAuthenticationListener;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASClaims;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASConnectionListener;
import com.ca.mas.foundation.MASDevice;
import com.ca.mas.foundation.MASException;
import com.ca.mas.foundation.MASOtpAuthenticationHandler;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import com.ca.mas.foundation.MASSecurityConfiguration;
import com.ca.mas.foundation.MASServerException;
import com.ca.mas.foundation.auth.MASAuthenticationProviders;
import com.ca.mas.foundation.notify.Callback;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;
import net.minidev.json.reader.JsonWriterI;
import org.json.JSONObject;

public class MAS {
    public static String TAG = "MAS";
    public static boolean DEBUG = Log.isLoggable((String)TAG, (int)2);
    private static Context appContext;
    private static Activity currentActivity;
    private static boolean hasRegisteredActivityCallback;
    private static MASAuthenticationListener masAuthenticationListener;
    private static int state;

    private static synchronized void init(@NonNull Context context) {
        MAS.stop();
        appContext = context.getApplicationContext();
        if (context instanceof Activity) {
            currentActivity = (Activity)context;
        }
        MAS.registerActivityLifecycleCallbacks((Application)appContext);
        new MASConfiguration(appContext);
        ConfigurationManager.getInstance().setMobileSsoListener(new MASMobileSsoListener(appContext));
    }

    private static void registerActivityLifecycleCallbacks(Application application) {
        if (hasRegisteredActivityCallback) {
            return;
        }
        hasRegisteredActivityCallback = true;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                currentActivity = activity;
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
                Activity currentActivity;
                if (currentActivity != null && (currentActivity = currentActivity) == activity) {
                    currentActivity = null;
                }
            }
        });
    }

    private static Class<Activity> getLoginActivity() {
        try {
            return Class.forName("com.ca.mas.ui.MASLoginActivity");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<Activity> getOtpActivity() {
        try {
            return Class.forName("com.ca.mas.ui.otp.MASOtpActivity");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void debug() {
        DEBUG = true;
    }

    public static void start(@NonNull Context context) {
        MAS.init(context);
        MobileSsoFactory.getInstance(context);
        state = 3;
        EventDispatcher.STARTED.notifyObservers();
    }

    public static void start(@NonNull Context context, boolean shouldUseDefault) {
        MAS.init(context);
        MobileSsoFactory.getInstance(context, shouldUseDefault);
        state = 3;
        EventDispatcher.STARTED.notifyObservers();
    }

    public static void start(@NonNull Context context, JSONObject jsonConfiguration) {
        MAS.init(context);
        MobileSsoFactory.getInstance(context, jsonConfiguration);
        state = 3;
        EventDispatcher.STARTED.notifyObservers();
    }

    public static void start(@NonNull Context context, URL url) {
        MAS.init(context);
        MobileSsoFactory.getInstance(context, url);
        state = 3;
        EventDispatcher.STARTED.notifyObservers();
    }

    public static void start(final @NonNull Context context, final URL url, final MASCallback<Void> callback) {
        if (url == null) {
            try {
                MAS.start(context);
                Callback.onSuccess(callback, null);
            }
            catch (Exception e) {
                Callback.onError(callback, e);
            }
            return;
        }
        final Uri uri = Uri.parse((String)url.toString());
        final String publicKeyHash = uri.getQueryParameter("subjectKeyHash");
        if (publicKeyHash == null || publicKeyHash.trim().isEmpty()) {
            Callback.onError(callback, new IllegalArgumentException("subjectKeyHash is not provided."));
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    MASSecurityConfiguration enrollmentConfig = new MASSecurityConfiguration.Builder().add(publicKeyHash).host(uri).build();
                    MAGHttpClient client = new MAGHttpClient();
                    MAGRequest request = new MAGRequest.MAGRequestBuilder(url).responseBody(MAGResponseBody.jsonBody()).setPublic().build();
                    MAGResponse response = client.execute(request, enrollmentConfig);
                    if (response.getResponseCode() != 200) {
                        throw ServerClient.createServerException(response, MASServerException.class);
                    }
                    MAS.start(context, (JSONObject)response.getBody().getContent());
                    Callback.onSuccess(callback, null);
                }
                catch (Exception e) {
                    Callback.onError(callback, e);
                }
                return null;
            }
        }.execute((Object[])new Void[]{null});
    }

    public static <T> long invoke(final MASRequest request, final MASCallback<MASResponse<T>> callback) {
        return MobileSsoFactory.getInstance().processRequest(request, new MAGResultReceiver<T>(Callback.getHandler(callback)){

            @Override
            public void onSuccess(final MAGResponse<T> response) {
                Callback.onSuccess(callback, new MASResponse<T>(){

                    @Override
                    public MASResponseBody<T> getBody() {
                        return new MASResponseBody<T>(){

                            @Override
                            public T getContent() {
                                if (response.getBody() == null) {
                                    return null;
                                }
                                return response.getBody().getContent();
                            }
                        };
                    }

                    @Override
                    public Map<String, List<String>> getHeaders() {
                        return response.getHeaders();
                    }

                    @Override
                    public int getResponseCode() {
                        return response.getResponseCode();
                    }

                    @Override
                    public String getResponseMessage() {
                        return response.getResponseMessage();
                    }
                });
            }

            @Override
            public void onError(MAGError error) {
                Callback.onError(callback, error);
            }

            @Override
            public void onRequestCancelled(Bundle data) {
                if (request.notifyOnCancel()) {
                    Callback.onError(callback, new RequestCancelledException(data));
                }
            }
        });
    }

    public static void setConfigurationFileName(String filename) {
        ConfigurationManager.getInstance().setConfigurationFileName(filename);
    }

    public static void gatewayIsReachable(final MASCallback<Boolean> callback) {
        new AsyncTaskLoader<Void>(MAS.getContext()){

            protected void onStartLoading() {
                super.onStartLoading();
                this.forceLoad();
            }

            public Void loadInBackground() {
                try {
                    Callback.onSuccess(callback, InetAddress.getByName(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTokenHost()).isReachable(1000));
                }
                catch (IOException e) {
                    Callback.onSuccess(callback, false);
                }
                return null;
            }
        }.startLoading();
    }

    public static void setConnectionListener(MASConnectionListener listener) {
        ConfigurationManager.getInstance().setConnectionListener(listener);
    }

    public static void setAuthenticationListener(MASAuthenticationListener listener) {
        masAuthenticationListener = listener;
    }

    public static boolean isAuthenticationListenerRegistered() {
        return masAuthenticationListener != null;
    }

    public static void setGrantFlow(int type) {
        switch (type) {
            case 1: {
                ConfigurationManager.getInstance().setDefaultGrantProvider(GrantProvider.CLIENT_CREDENTIALS);
                break;
            }
            case 2: {
                ConfigurationManager.getInstance().setDefaultGrantProvider(GrantProvider.PASSWORD);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Flow Type");
            }
        }
    }

    @Internal
    public static Context getContext() {
        return appContext;
    }

    @Internal
    public static Activity getCurrentActivity() {
        return currentActivity;
    }

    public static void cancelRequest(long requestId) {
        MobileSsoFactory.getInstance().cancelRequest(requestId, null);
    }

    public static void cancelRequest(long requestId, Bundle data) {
        MobileSsoFactory.getInstance().cancelRequest(requestId, data);
    }

    public static void cancelAllRequests() {
        MobileSsoFactory.getInstance().cancelAllRequests(null);
    }

    public static void cancelAllRequest(Bundle data) {
        MobileSsoFactory.getInstance().cancelAllRequests(data);
    }

    public static void processPendingRequests() {
        MobileSsoFactory.getInstance().processPendingRequests();
    }

    public static int getState(Context context) {
        if (state != 0) {
            return state;
        }
        ConfigurationManager.getInstance().init(context);
        try {
            ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider();
            ConfigurationManager.getInstance().reset();
            state = 2;
        }
        catch (Exception e) {
            state = 1;
        }
        return state;
    }

    public static void enablePKCE(boolean enablePKCE) {
        ConfigurationManager.getInstance().enablePKCE(enablePKCE);
    }

    public static boolean isPKCEEnabled() {
        return ConfigurationManager.getInstance().isPKCEEnabled();
    }

    public static void stop() {
        state = 4;
        EventDispatcher.STOP.notifyObservers();
        MobileSsoFactory.reset();
    }

    public static String sign(MASClaims masClaims) throws MASException {
        return MAS.sign(masClaims, StorageProvider.getInstance().getTokenManager().getClientPrivateKey());
    }

    public static String sign(MASClaims masClaims, PrivateKey privateKey) throws MASException {
        if (!MASDevice.getCurrentDevice().isRegistered()) {
            throw new IllegalStateException("Device not registered.");
        }
        RSASSASigner signer = new RSASSASigner(privateKey);
        JWTClaimsSet.Builder claimBuilder = new JWTClaimsSet.Builder();
        claimBuilder.jwtID(masClaims.getJwtId()).issuer(masClaims.getIssuer()).notBeforeTime(masClaims.getNotBefore()).expirationTime(masClaims.getExpirationTime()).issueTime(masClaims.getIssuedAt()).audience(masClaims.getAudience()).subject(masClaims.getSubject());
        for (Map.Entry<String, Object> entry : masClaims.getClaims().entrySet()) {
            claimBuilder.claim(entry.getKey(), entry.getValue());
        }
        JWSHeader rs256Header = new JWSHeader(JWSAlgorithm.RS256);
        SignedJWT claimsToken = new SignedJWT(rs256Header, claimBuilder.build());
        try {
            claimsToken.sign((JWSSigner)signer);
            return claimsToken.serialize();
        }
        catch (JOSEException e) {
            throw new MASException(e);
        }
    }

    static {
        JSONValue.defaultWriter.registerWriter((JsonWriterI)new JsonWriterI<JSONObject>(){

            public void writeJSONString(JSONObject value, Appendable out, JSONStyle compression) throws IOException {
                out.append(value.toString());
            }
        }, new Class[]{JSONObject.class});
    }

    public static class RequestCancelledException
    extends Exception {
        private Bundle data;

        public RequestCancelledException(Bundle data) {
            this.data = data;
        }

        public Bundle getData() {
            return this.data;
        }
    }

    private static class MASMobileSsoListener
    implements MobileSsoListener {
        private Context mAppContext;

        MASMobileSsoListener(Context context) {
            this.mAppContext = context;
        }

        @Override
        public void onAuthenticateRequest(long requestId, AuthenticationProvider provider) {
            if (masAuthenticationListener == null) {
                Class loginActivity = MAS.getLoginActivity();
                if (loginActivity != null) {
                    if (this.mAppContext != null) {
                        Intent intent = new Intent(this.mAppContext, loginActivity);
                        intent.addFlags(0x10000000);
                        intent.putExtra("com.ca.mas.core.service.req.extra.requestId", requestId);
                        intent.putExtra("com.ca.mas.core.service.req.extra.social.login.providers", (Parcelable)new MASAuthenticationProviders(provider));
                        this.mAppContext.startActivity(intent);
                    }
                } else if (DEBUG) {
                    Log.w((String)TAG, (String)(MASAuthenticationListener.class.getSimpleName() + " is required for user authentication."));
                }
            } else {
                masAuthenticationListener.onAuthenticateRequest((Context)currentActivity, requestId, new MASAuthenticationProviders(provider));
            }
        }

        @Override
        public void onOtpAuthenticationRequest(OtpAuthenticationHandler otpAuthenticationHandler) {
            if (masAuthenticationListener == null) {
                Class otpActivity = MAS.getOtpActivity();
                if (otpActivity != null) {
                    if (this.mAppContext != null) {
                        Intent intent = new Intent(this.mAppContext, otpActivity);
                        intent.addFlags(0x10000000);
                        intent.putExtra("com.ca.mas.core.service.req.extra.auth.otp.handler", (Parcelable)new MASOtpAuthenticationHandler(otpAuthenticationHandler));
                        this.mAppContext.startActivity(intent);
                    }
                } else if (DEBUG) {
                    Log.w((String)TAG, (String)(MASAuthenticationListener.class.getSimpleName() + " is required for otp authentication."));
                }
            } else {
                masAuthenticationListener.onOtpAuthenticateRequest((Context)currentActivity, new MASOtpAuthenticationHandler(otpAuthenticationHandler));
            }
        }
    }
}

