/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.storage.implementation;

import android.content.Context;
import android.util.Log;
import com.ca.mas.core.security.KeyStore;
import com.ca.mas.core.security.KeyStoreAdapter;
import com.ca.mas.core.storage.Storage;
import com.ca.mas.core.storage.StorageException;
import com.ca.mas.core.storage.StorageResult;
import com.ca.mas.core.storage.StorageResultReceiver;
import com.ca.mas.core.storage.implementation.MASStorageManager;
import com.ca.mas.foundation.MAS;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public final class KeyStoreStorage
extends Storage {
    private KeyStore ks;
    private String prefix = "";
    private static int MAX_KEY_SIZE = 120;
    private static final int MAX_DATA_SIZE = 32768;

    protected KeyStoreStorage(Object options) throws StorageException {
        super(options);
        Context ctx;
        if (options == null || !(options instanceof Object[])) {
            throw new StorageException(111);
        }
        Object[] inputs = (Object[])options;
        try {
            ctx = (Context)inputs[0];
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)"Missing Context input.", (Throwable)e);
            }
            throw new StorageException(111);
        }
        try {
            this.prefix = (Boolean)inputs[1] != false ? "SHARED_" : ctx.getPackageName() + "_";
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.w((String)MAS.TAG, (String)"Wrong shared input attribute, falling back to private.", (Throwable)e);
            }
            this.prefix = ctx.getPackageName() + "_";
        }
        this.ks = KeyStoreAdapter.getKeyStore();
    }

    @Override
    public MASStorageManager.MASStorageType getType() {
        return MASStorageManager.MASStorageType.TYPE_KEYSTORE;
    }

    @Override
    public StorageResult writeData(String key, byte[] value) throws StorageException {
        this.validateInputs(key, value);
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.WRITE);
        if (!this.isReady(returnValue)) {
            return returnValue;
        }
        StorageException returnException = null;
        try {
            if (this.readData(key).getStatus() == StorageResult.StorageOperationStatus.SUCCESS) {
                returnException = new StorageException(104);
            } else {
                key = this.sanitizeKey(key);
                boolean status = this.ks.put(key, value);
                try {
                    this.checkForError(status);
                }
                catch (StorageException e) {
                    returnException = e;
                }
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)"KeyStoreStorage write error.", (Throwable)e);
            }
            returnException = new StorageException(110);
        }
        if (returnException != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnException);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(key.substring(this.prefix.length()));
        }
        return returnValue;
    }

    @Override
    public void writeData(String key, byte[] value, StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.writeData(key, value);
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult writeString(String key, String value) throws StorageException {
        StorageResult returnValue;
        this.validateInputs(key, value);
        try {
            returnValue = this.writeData(key, value.getBytes("UTF-8"));
            returnValue.setType(StorageResult.StorageOperationType.WRITE_STRING);
        }
        catch (UnsupportedEncodingException ignore) {
            throw new StorageException(109);
        }
        return returnValue;
    }

    @Override
    public void writeString(String key, String value, StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.writeString(key, value);
        returnValue.setType(StorageResult.StorageOperationType.WRITE_STRING);
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult readData(String key) throws StorageException {
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.READ);
        if (key == null) {
            throw new StorageException(101);
        }
        if ((key = this.sanitizeKey(key)).length() > MAX_KEY_SIZE) {
            throw new StorageException(151);
        }
        if (!this.isReady(returnValue)) {
            return returnValue;
        }
        StorageException returnError = null;
        try {
            byte[] value = this.ks.get(key);
            if (value == null) {
                returnError = new StorageException(105);
            } else {
                returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
                returnValue.setData(value);
            }
        }
        catch (Exception e) {
            returnError = new StorageException(110);
        }
        if (returnError != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnError);
        }
        return returnValue;
    }

    @Override
    public void readData(String key, StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.readData(key);
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult readString(String key) throws StorageException {
        StorageException returnError;
        StorageResult returnValue;
        block10: {
            returnValue = new StorageResult(StorageResult.StorageOperationType.READ_STRING);
            if (key == null) {
                throw new StorageException(101);
            }
            if ((key = this.sanitizeKey(key)).length() > MAX_KEY_SIZE) {
                throw new StorageException(151);
            }
            if (!this.isReady(returnValue)) {
                return returnValue;
            }
            returnError = null;
            try {
                String stringValue;
                byte[] value = this.ks.get(key);
                if (value == null) {
                    returnError = new StorageException(105);
                    break block10;
                }
                returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
                try {
                    stringValue = new String(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (MAS.DEBUG) {
                        Log.w((String)MAS.TAG, (String)("The data is not UTF-8 " + e));
                    }
                    stringValue = new String(value);
                }
                returnValue.setData(stringValue);
            }
            catch (Exception e) {
                returnError = new StorageException(110);
            }
        }
        if (returnError != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnError);
        }
        return returnValue;
    }

    @Override
    public void readString(String key, StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.readString(key);
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult updateData(String key, byte[] value) throws StorageException {
        this.validateInputs(key, value);
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.UPDATE);
        if (!this.isReady(returnValue)) {
            return returnValue;
        }
        StorageException returnException = null;
        try {
            if (this.readData(key).getStatus() == StorageResult.StorageOperationStatus.SUCCESS) {
                key = this.sanitizeKey(key);
                boolean status = this.ks.put(key, value);
                try {
                    this.checkForError(status);
                }
                catch (StorageException e) {
                    returnException = e;
                }
            } else {
                returnException = new StorageException(105);
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)("update error " + e));
            }
            returnException = new StorageException(110);
        }
        if (returnException != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnException);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(key.substring(this.prefix.length()));
        }
        return returnValue;
    }

    @Override
    public void updateData(String key, byte[] value, StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.updateData(key, value);
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult updateString(String key, String value) throws StorageException {
        this.validateInputs(key, value);
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.UPDATE_STRING);
        if (!this.isReady(returnValue)) {
            return returnValue;
        }
        StorageException returnException = null;
        try {
            if (this.readData(key).getStatus() == StorageResult.StorageOperationStatus.SUCCESS) {
                key = this.sanitizeKey(key);
                boolean status = this.ks.put(key, value.getBytes("UTF-8"));
                try {
                    this.checkForError(status);
                }
                catch (StorageException e) {
                    returnException = e;
                }
            } else {
                returnException = new StorageException(105);
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)("update string error " + e));
            }
            returnException = new StorageException(110);
        }
        if (returnException != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnException);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(key.substring(this.prefix.length()));
        }
        return returnValue;
    }

    @Override
    public void updateString(String key, String value, StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.updateString(key, value);
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult writeOrUpdateData(String key, byte[] value) throws StorageException {
        this.validateInputs(key, value);
        key = this.sanitizeKey(key);
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.WRITE_OR_UPDATE);
        StorageException returnException = null;
        try {
            boolean status = this.ks.put(key, value);
            try {
                this.checkForError(status);
            }
            catch (StorageException e) {
                returnException = e;
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)("write/update error " + e));
            }
            returnException = new StorageException(110);
        }
        if (returnException != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnException);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(key.substring(this.prefix.length()));
        }
        return returnValue;
    }

    @Override
    public void writeOrUpdateData(String key, byte[] value, StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.writeOrUpdateData(key, value);
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult writeOrUpdateString(String key, String value) throws StorageException {
        this.validateInputs(key, value);
        key = this.sanitizeKey(key);
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.WRITE_OR_UPDATE_STRING);
        StorageException returnException = null;
        try {
            boolean status = this.ks.put(key, value.getBytes("UTF-8"));
            try {
                this.checkForError(status);
            }
            catch (StorageException e) {
                returnException = e;
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)("write/update string error " + e));
            }
            returnException = new StorageException(110);
        }
        if (returnException != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnException);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(key.substring(this.prefix.length()));
        }
        return returnValue;
    }

    @Override
    public void writeOrUpdateString(String key, String value, StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.writeOrUpdateString(key, value);
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult deleteData(String key) throws StorageException {
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.DELETE);
        if (key == null) {
            throw new StorageException(101);
        }
        if (key.length() > MAX_KEY_SIZE) {
            throw new StorageException(151);
        }
        if (!this.isReady(returnValue)) {
            return returnValue;
        }
        StorageException returnException = null;
        try {
            if (this.readData(key).getStatus() != StorageResult.StorageOperationStatus.SUCCESS) {
                returnException = new StorageException(105);
            } else {
                key = this.sanitizeKey(key);
                boolean status = this.ks.delete(key);
                try {
                    this.checkForError(status);
                }
                catch (StorageException e) {
                    returnException = e;
                }
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)("delete error " + e));
            }
            returnException = new StorageException(110);
        }
        if (returnException != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnException);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(key.substring(this.prefix.length()));
        }
        return returnValue;
    }

    @Override
    public StorageResult deleteString(String key) throws StorageException {
        StorageResult result = this.deleteData(key);
        result.setType(StorageResult.StorageOperationType.DELETE_STRING);
        return result;
    }

    @Override
    public void deleteData(String key, StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.deleteData(key);
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public void deleteString(String key, StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.deleteString(key);
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult deleteAll() {
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.DELETE_ALL);
        StorageException returnError = null;
        int successCount = 0;
        int failureCount = 0;
        try {
            ArrayList screenedKeys = (ArrayList)this.getAllKeys().getData();
            for (String currentKey : screenedKeys) {
                try {
                    if (this.ks.delete(this.prefix + currentKey)) {
                        ++successCount;
                        continue;
                    }
                    ++failureCount;
                }
                catch (Exception e) {
                    ++failureCount;
                }
            }
            if (failureCount != 0) {
                String msg = "Failed to deleteData " + failureCount + " entries. Entries deleted: " + successCount;
                if (MAS.DEBUG) {
                    Log.e((String)MAS.TAG, (String)msg);
                }
                returnError = new StorageException(msg, null, 110);
            } else if (MAS.DEBUG) {
                Log.i((String)MAS.TAG, (String)("Deleted " + successCount + " entries "));
            }
        }
        catch (Exception e) {
            returnError = new StorageException(110);
        }
        if (returnError != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnError);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(successCount);
        }
        return returnValue;
    }

    @Override
    public void deleteAll(StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.deleteAll();
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult getAllKeys() {
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.GET_ALL_KEYS);
        if (!this.isReady(returnValue)) {
            return returnValue;
        }
        StorageException returnError = null;
        ArrayList<String> keys = new ArrayList<String>();
        try {
            String[] realKeys = this.ks.saw("");
            if (realKeys != null && realKeys.length > 0) {
                for (String key : realKeys) {
                    if (!key.startsWith(this.prefix)) continue;
                    keys.add(key.substring(this.prefix.length()));
                }
            }
        }
        catch (Exception e) {
            returnError = new StorageException(110);
        }
        if (returnError != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnError);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(keys);
        }
        return returnValue;
    }

    @Override
    public void getAllKeys(StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.getAllKeys();
        this.notifyCallback(callback, returnValue);
    }

    private String sanitizeKey(String key) {
        return key == null ? key : this.prefix + key;
    }

    private void validateInputs(String key, byte[] value) throws StorageException {
        if (key == null) {
            throw new StorageException(101);
        }
        if ((key = this.sanitizeKey(key)).length() > MAX_KEY_SIZE) {
            throw new StorageException(151);
        }
        if (value == null) {
            throw new StorageException(102);
        }
        if (value.length > 32768) {
            throw new StorageException(152);
        }
    }

    private void validateInputs(String key, String value) throws StorageException {
        byte[] byteData;
        if (key == null) {
            throw new StorageException(101);
        }
        if ((key = this.sanitizeKey(key)).length() > MAX_KEY_SIZE) {
            throw new StorageException(151);
        }
        if (value == null) {
            throw new StorageException(102);
        }
        try {
            byteData = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StorageException(109);
        }
        if (byteData.length > 32768) {
            throw new StorageException(152);
        }
    }

    private void notifyCallback(StorageResultReceiver callback, StorageResult result) {
        block4: {
            if (callback == null && MAS.DEBUG) {
                Log.w((String)MAS.TAG, (String)"No KeyStoreStorage callback set.");
            }
            if (callback != null) {
                try {
                    callback.send(result);
                }
                catch (Exception e) {
                    if (!MAS.DEBUG) break block4;
                    Log.w((String)MAS.TAG, (String)"KeyStoreStorage threw exception: ", (Throwable)e);
                }
            }
        }
    }

    private void checkForError(boolean success) throws StorageException {
        if (!success) {
            int code = this.ks.getLastError();
            if (code == 1) {
                if (!this.ks.isUnlocked()) {
                    throw new StorageException(153);
                }
                throw new StorageException(100);
            }
            String errorStr = this.rcToStr(code);
            if (MAS.DEBUG) {
                Log.d((String)MAS.TAG, (String)("last error = " + errorStr));
            }
            throw new StorageException("KeyStore error: " + errorStr, null, 110);
        }
    }

    private String rcToStr(int rc) {
        switch (rc) {
            case 1: {
                return "NO_ERROR";
            }
            case 2: {
                return "LOCKED";
            }
            case 3: {
                return "UNINITIALIZED";
            }
            case 4: {
                return "SYSTEM_ERROR";
            }
            case 5: {
                return "PROTOCOL_ERROR";
            }
            case 6: {
                return "PERMISSION_DENIED";
            }
            case 7: {
                return "KEY_NOT_FOUND";
            }
            case 8: {
                return "VALUE_CORRUPTED";
            }
            case 9: {
                return "UNDEFINED_ACTION";
            }
            case 10: {
                return "WRONG_PASSWORD";
            }
        }
        return "Unknown RC";
    }

    private boolean isReady(StorageResult result) {
        try {
            if (!this.ks.isUnlocked()) {
                result.setStatus(StorageResult.StorageOperationStatus.FAILURE);
                result.setData(new StorageException(153));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            result.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            result.setData(new StorageException(100));
            return false;
        }
    }
}

