/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.service;

import android.app.IntentService;
import android.content.Intent;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.util.Log;
import com.ca.mas.core.MobileSsoListener;
import com.ca.mas.core.auth.AuthenticationException;
import com.ca.mas.core.auth.otp.OtpAuthenticationHandler;
import com.ca.mas.core.auth.otp.model.OtpResponseHeaders;
import com.ca.mas.core.clientcredentials.ClientCredentialsException;
import com.ca.mas.core.clientcredentials.ClientCredentialsServerException;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.oauth.OAuthClient;
import com.ca.mas.core.oauth.OAuthException;
import com.ca.mas.core.oauth.OAuthServerException;
import com.ca.mas.core.policy.exceptions.CredentialRequiredException;
import com.ca.mas.core.policy.exceptions.LocationInvalidException;
import com.ca.mas.core.policy.exceptions.LocationRequiredException;
import com.ca.mas.core.policy.exceptions.MobileNumberInvalidException;
import com.ca.mas.core.policy.exceptions.MobileNumberRequiredException;
import com.ca.mas.core.policy.exceptions.OtpException;
import com.ca.mas.core.policy.exceptions.TokenStoreUnavailableException;
import com.ca.mas.core.registration.DeviceRegistrationAwaitingActivationException;
import com.ca.mas.core.registration.RegistrationException;
import com.ca.mas.core.registration.RegistrationServerException;
import com.ca.mas.core.request.internal.AuthenticateRequest;
import com.ca.mas.core.service.AuthenticationProvider;
import com.ca.mas.core.service.MssoActiveQueue;
import com.ca.mas.core.service.MssoExecutorService;
import com.ca.mas.core.service.MssoRequest;
import com.ca.mas.core.service.MssoRequestQueue;
import com.ca.mas.core.service.MssoResponse;
import com.ca.mas.core.service.MssoResponseQueue;
import com.ca.mas.core.service.MssoState;
import com.ca.mas.core.token.JWTExpiredException;
import com.ca.mas.core.token.JWTInvalidAUDException;
import com.ca.mas.core.token.JWTInvalidAZPException;
import com.ca.mas.core.token.JWTInvalidSignatureException;
import com.ca.mas.core.token.JWTValidationException;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class MssoService
extends IntentService {
    public MssoService() {
        super("MssoService");
    }

    protected void onHandleIntent(Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            if (MAS.DEBUG) {
                Log.w((String)MAS.TAG, (String)"Intent did not contain an action");
            }
            return;
        }
        Bundle extras = intent.getExtras();
        if (extras == null || !extras.containsKey("com.ca.mas.core.service.req.extra.requestId")) {
            if (MAS.DEBUG) {
                Log.w((String)MAS.TAG, (String)"Intent did not contain extras that included a request ID");
            }
            return;
        }
        long requestId = extras.getLong("com.ca.mas.core.service.req.extra.requestId");
        if (requestId == -1L) {
            this.onProcessAllPendingRequests();
            return;
        }
        MssoRequest request = this.takeActiveRequest(requestId);
        if (request == null) {
            if (MAS.DEBUG) {
                Log.d((String)MAS.TAG, (String)"Request ID not found, assuming request is canceled or already processed");
            }
            return;
        }
        if ("com.ca.mas.core.service.action.PROCESS_REQUEST".equals(action)) {
            this.startThreadedRequest(request);
            return;
        }
        if ("com.ca.mas.core.service.action.CREDENTIALS_OBTAINED".equals(action)) {
            this.onCredentialsObtained(extras, request);
            return;
        }
        if ("com.ca.mas.core.service.action.VALIDATE_OTP".equals(action)) {
            this.onOtpObtained(extras, request);
            return;
        }
        if (MAS.DEBUG) {
            Log.w((String)MAS.TAG, (String)("Ignoring intent with unrecognized action " + action));
        }
    }

    private void startThreadedRequest(final MssoRequest request) {
        MssoExecutorService.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                MssoService.this.onProcessRequest(request);
            }
        });
    }

    private void onOtpObtained(Bundle extras, MssoRequest request) {
        Bundle bundle = new Bundle();
        bundle.putString("X-OTP", extras.getString("com.ca.mas.core.service.req.extra.auth.otp.value"));
        bundle.putString("X-OTP-CHANNEL", extras.getString("com.ca.mas.core.service.req.extra.auth.otp.channels"));
        request.setExtra(bundle);
        this.startThreadedRequest(request);
    }

    private void onCredentialsObtained(Bundle extras, MssoRequest request) {
        MASAuthCredentials creds = (MASAuthCredentials)extras.getParcelable("com.ca.mas.core.service.req.extra.credentials");
        request.getMssoContext().setCredentials(creds);
        boolean originalRequestProcessed = false;
        if (request.getRequest() instanceof AuthenticateRequest) {
            originalRequestProcessed = true;
            this.onProcessRequest(request);
        }
        ArrayList<MssoRequest> requests = new ArrayList<MssoRequest>(MssoActiveQueue.getInstance().getAllRequest());
        for (MssoRequest mssoRequest : requests) {
            if (request == mssoRequest) {
                originalRequestProcessed = true;
            }
            this.startThreadedRequest(mssoRequest);
        }
        if (!originalRequestProcessed) {
            this.startThreadedRequest(request);
        }
    }

    private void onProcessAllPendingRequests() {
        ArrayList<MssoRequest> requests = new ArrayList<MssoRequest>(MssoActiveQueue.getInstance().getAllRequest());
        for (MssoRequest mssoRequest : requests) {
            this.startThreadedRequest(mssoRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProcessRequest(MssoRequest request) {
        ResultReceiver receiver = request.getResultReceiver();
        boolean expectingUnlock = false;
        MssoContext mssoContext = request.getMssoContext();
        try {
            MAGResponse magResponse = mssoContext.executeRequest(request.getExtra(), request.getRequest());
            if (this.requestFinished(request)) {
                MssoResponse response = this.createMssoResponse(request, magResponse);
                MssoResponseQueue.getInstance().addResponse(response);
                this.respondSuccess(receiver, response.getId(), "OK");
            }
            MssoState.setExpectingUnlock(false);
        }
        catch (CredentialRequiredException e) {
            if (MAS.DEBUG) {
                Log.d((String)MAS.TAG, (String)"Request for user credentials");
            }
            MobileSsoListener mobileSsoListener = ConfigurationManager.getInstance().getMobileSsoListener();
            try {
                AuthenticationProvider authProvider = new OAuthClient(request.getMssoContext()).getSocialPlatformProvider(this.getApplicationContext());
                if (mobileSsoListener != null) {
                    mobileSsoListener.onAuthenticateRequest(request.getId(), authProvider);
                } else if (MAS.DEBUG) {
                    Log.w((String)MAS.TAG, (String)"No Authentication listener is registered");
                }
            }
            catch (OAuthException | OAuthServerException e1) {
                if (MAS.DEBUG) {
                    Log.e((String)MAS.TAG, (String)e1.getMessage(), (Throwable)e1);
                }
                this.requestFinished(request);
                this.respondError(request.getResultReceiver(), 6, new MAGError(e1));
            }
        }
        catch (TokenStoreUnavailableException e) {
            try {
                expectingUnlock = true;
                mssoContext.getTokenManager().getTokenStore().unlock();
            }
            catch (Exception e1) {
                this.requestFinished(request);
                this.respondError(receiver, 3, new MAGError(e));
            }
        }
        catch (OtpException e) {
            OtpResponseHeaders otpResponseHeaders = e.getOtpResponseHeaders();
            MobileSsoListener mobileSsoListener = ConfigurationManager.getInstance().getMobileSsoListener();
            if (mobileSsoListener != null) {
                if (OtpResponseHeaders.X_OTP_VALUE.REQUIRED.equals((Object)otpResponseHeaders.getxOtpValue())) {
                    mobileSsoListener.onOtpAuthenticationRequest(new OtpAuthenticationHandler(request.getId(), otpResponseHeaders.getChannels(), false, null));
                } else if (OtpResponseHeaders.X_CA_ERROR.OTP_INVALID == otpResponseHeaders.getErrorCode()) {
                    Bundle extra = request.getExtra();
                    String selectedChannels = null;
                    if (extra != null) {
                        selectedChannels = extra.getString("X-OTP-CHANNEL");
                    }
                    OtpAuthenticationHandler otpHandler = new OtpAuthenticationHandler(request.getId(), otpResponseHeaders.getChannels(), true, selectedChannels);
                    mobileSsoListener.onOtpAuthenticationRequest(otpHandler);
                }
                return;
            }
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)e.getMessage(), (Throwable)e);
            }
            this.requestFinished(request);
            this.respondError(receiver, this.getErrorCode(e), new MAGError(e));
        }
        catch (Exception e2) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)e2.getMessage(), (Throwable)e2);
            }
            this.requestFinished(request);
            this.respondError(receiver, this.getErrorCode(e2), new MAGError(e2));
        }
        finally {
            MssoState.setExpectingUnlock(expectingUnlock);
        }
    }

    private int getErrorCode(Throwable exception) {
        try {
            throw exception;
        }
        catch (DeviceRegistrationAwaitingActivationException e) {
            return 5;
        }
        catch (ClientCredentialsException | ClientCredentialsServerException e) {
            return -901;
        }
        catch (RegistrationException | RegistrationServerException e) {
            return 7;
        }
        catch (OAuthException | OAuthServerException e) {
            return 6;
        }
        catch (LocationRequiredException e) {
            return -301;
        }
        catch (LocationInvalidException e) {
            return -302;
        }
        catch (MobileNumberRequiredException e) {
            return -601;
        }
        catch (MobileNumberInvalidException e) {
            return -602;
        }
        catch (JWTInvalidAUDException e) {
            return -702;
        }
        catch (JWTInvalidAZPException e) {
            return -703;
        }
        catch (JWTExpiredException e) {
            return -704;
        }
        catch (JWTInvalidSignatureException e) {
            return -701;
        }
        catch (JWTValidationException e) {
            return -705;
        }
        catch (AuthenticationException e) {
            return 401;
        }
        catch (IOException e) {
            return 2;
        }
        catch (Throwable e) {
            if (e.getCause() == null) {
                return 3;
            }
            return this.getErrorCode(e.getCause());
        }
    }

    private MssoResponse createMssoResponse(MssoRequest request, MAGResponse response) {
        return new MssoResponse(request, response);
    }

    private MssoRequest takeActiveRequest(long requestId) {
        MssoRequest request = MssoRequestQueue.getInstance().takeRequest(requestId);
        if (request != null) {
            MssoActiveQueue.getInstance().addRequest(request);
            return request;
        }
        request = MssoActiveQueue.getInstance().getRequest(requestId);
        return request;
    }

    private boolean requestFinished(MssoRequest request) {
        return null != MssoActiveQueue.getInstance().takeRequest(request.getId());
    }

    private void respondError(ResultReceiver receiver, int resultCode, MAGError error) {
        if (receiver != null) {
            Bundle resultData = new Bundle();
            resultData.putSerializable("com.ca.mas.core.service.result.error", (Serializable)error);
            resultData.putString("com.ca.mas.core.service.result.errorMessage", error.getMessage());
            receiver.send(resultCode, resultData);
        }
    }

    private void respondSuccess(ResultReceiver receiver, long requestId, String errorMessage) {
        if (receiver != null) {
            Bundle resultData = new Bundle();
            resultData.putString("com.ca.mas.core.service.result.errorMessage", errorMessage);
            resultData.putLong("com.ca.mas.core.service.result.requestId", requestId);
            receiver.send(0, resultData);
        }
    }
}

