/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.request.internal;

import android.util.Log;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.request.internal.LocalRequest;
import com.ca.mas.core.request.internal.MAGRequestProxy;
import com.ca.mas.foundation.MAS;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuthTokenRequest
extends MAGRequestProxy
implements LocalRequest {
    public static final String ACCESSTOKEN = "accesstoken";
    public static final String REFRESHTOKEN = "refreshtoken";
    public static final String EXPIRY = "expiry";

    public OAuthTokenRequest() {
        this.request = new MAGRequest.MAGRequestBuilder((URL)null).password().build();
    }

    @Override
    public MAGResponse send(final MssoContext context) throws IOException {
        return new MAGResponse<JSONObject>(){
            String accessToken;
            String refreshToken;
            long expiry;
            {
                this.accessToken = context.getAccessToken();
                this.refreshToken = context.getRefreshToken();
                this.expiry = context.getAccessTokenExpiry();
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                return null;
            }

            @Override
            public int getResponseCode() {
                if (this.accessToken == null && this.refreshToken == null && this.expiry == 0L) {
                    return 404;
                }
                return 200;
            }

            @Override
            public String getResponseMessage() {
                return null;
            }

            @Override
            public MAGResponseBody<JSONObject> getBody() {
                if (this.getResponseCode() == 200) {
                    return new MAGResponseBody<JSONObject>(){

                        @Override
                        public JSONObject getContent() {
                            JSONObject entity = new JSONObject();
                            try {
                                entity.put(OAuthTokenRequest.ACCESSTOKEN, (Object)accessToken);
                                entity.put(OAuthTokenRequest.REFRESHTOKEN, (Object)refreshToken);
                                entity.put(OAuthTokenRequest.EXPIRY, expiry);
                            }
                            catch (JSONException e) {
                                if (MAS.DEBUG) {
                                    Log.i((String)MAS.TAG, (String)e.getMessage(), (Throwable)e);
                                }
                                return new JSONObject();
                            }
                            return entity;
                        }
                    };
                }
                return new MAGResponseBody<JSONObject>(){

                    @Override
                    public JSONObject getContent() {
                        return new JSONObject();
                    }
                };
            }
        };
    }
}

