/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import android.support.annotation.NonNull;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.exceptions.MobileNumberInvalidException;
import com.ca.mas.core.policy.exceptions.MobileNumberRequiredException;
import com.ca.mas.foundation.MAS;

class TelephoneAssertion
implements MssoAssertion {
    private TelephonyManager telephonyManager;

    TelephoneAssertion() {
    }

    @Override
    public void init(@NonNull MssoContext mssoContext, @NonNull Context sysContext) {
        block4: {
            ConfigurationProvider conf = mssoContext.getConfigurationProvider();
            if (conf == null) {
                throw new NullPointerException("mssoContext.configurationProvider");
            }
            Boolean enabled = (Boolean)conf.getProperty("msso.msisdn.enabled");
            if (enabled == null || !enabled.booleanValue()) {
                this.close();
                return;
            }
            try {
                this.initTelephonyManager(sysContext);
            }
            catch (Exception e) {
                if (!MAS.DEBUG) break block4;
                Log.d((String)MAS.TAG, (String)("Unable to access telephone manager: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void initTelephonyManager(Context sysContext) {
        this.telephonyManager = (TelephonyManager)sysContext.getSystemService("phone");
    }

    @Override
    public void processResponse(MssoContext mssoContext, RequestInfo request, MAGResponse response) throws MAGException {
        String responseContent;
        int statusCode = response.getResponseCode();
        if (statusCode >= 400 && statusCode < 500 && (responseContent = new String(response.getBody().getRawContent())).toLowerCase().contains("msisdn")) {
            if (statusCode == 449) {
                throw new MobileNumberRequiredException("MSISDN is required by the application to function properly. Enable MSISDN permission.");
            }
            if (statusCode == 448) {
                throw new MobileNumberInvalidException("MSISDN is not authorized to access protected resource.");
            }
        }
    }

    @Override
    public void processRequest(MssoContext mssoContext, RequestInfo request) {
        block3: {
            if (this.telephonyManager != null) {
                try {
                    request.getRequest().addHeader("MSISDN", this.telephonyManager.getLine1Number());
                }
                catch (SecurityException e) {
                    if (!MAS.DEBUG) break block3;
                    Log.d((String)MAS.TAG, (String)("No permission to access phone state: " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.telephonyManager != null) {
            this.telephonyManager = null;
        }
    }
}

