/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import android.support.annotation.NonNull;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.security.SecureLockException;
import com.ca.mas.core.store.TokenManager;

class SecureLockAssertion
implements MssoAssertion {
    private TokenManager tokenManager;

    SecureLockAssertion() {
    }

    @Override
    public void init(@NonNull MssoContext mssoContext, @NonNull Context sysContext) {
        this.tokenManager = mssoContext.getTokenManager();
        if (mssoContext.getConfigurationProvider() == null) {
            throw new NullPointerException("ConfigurationProvider is null");
        }
    }

    @Override
    public void processRequest(MssoContext mssoContext, RequestInfo request) throws SecureLockException {
        byte[] secureToken = this.tokenManager.getSecureIdToken();
        if (secureToken != null) {
            mssoContext.clearAccessToken();
            throw new SecureLockException("The session is currently locked.");
        }
    }

    @Override
    public void processResponse(MssoContext mssoContext, RequestInfo request, MAGResponse response) {
    }

    @Override
    public void close() {
    }
}

