/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.error.MAGStateException;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.policy.AccessTokenAssertion;
import com.ca.mas.core.policy.ClientCredentialAssertion;
import com.ca.mas.core.policy.DeviceRegistrationAssertion;
import com.ca.mas.core.policy.LocationAssertion;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.OtpAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.SecureLockAssertion;
import com.ca.mas.core.policy.StorageReadyAssertion;
import com.ca.mas.core.policy.TelephoneAssertion;
import java.util.ArrayList;
import java.util.List;

public class PolicyManager {
    private final MssoContext mssoContext;
    private final List<MssoAssertion> policies = new ArrayList<MssoAssertion>();
    private final Object policySync = new Object();

    public PolicyManager(MssoContext mssoContext) {
        this.mssoContext = mssoContext;
        List customPolicies = (List)mssoContext.getConfigurationProvider().getProperty("msso.add.custom.policies");
        if (customPolicies != null && !customPolicies.isEmpty()) {
            for (String policy : customPolicies) {
                try {
                    this.policies.add((MssoAssertion)Class.forName(policy).newInstance());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to initialize policy: " + policy, e);
                }
            }
        }
        this.policies.add(new StorageReadyAssertion());
        this.policies.add(new SecureLockAssertion());
        this.policies.add(new ClientCredentialAssertion());
        this.policies.add(new DeviceRegistrationAssertion());
        this.policies.add(new AccessTokenAssertion());
        this.policies.add(new LocationAssertion());
        this.policies.add(new TelephoneAssertion());
        this.policies.add(new OtpAssertion());
    }

    public void init(Context sysContext) {
        for (MssoAssertion policy : this.policies) {
            policy.init(this.mssoContext, sysContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(RequestInfo request) throws MAGStateException, MAGException, MAGServerException {
        Object object = this.policySync;
        synchronized (object) {
            for (MssoAssertion policy : this.policies) {
                policy.processRequest(this.mssoContext, request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(RequestInfo request, MAGResponse response) throws MAGException, MAGServerException {
        Object object = this.policySync;
        synchronized (object) {
            for (MssoAssertion policy : this.policies) {
                policy.processResponse(this.mssoContext, request, response);
            }
        }
    }

    public void close() {
        for (MssoAssertion policy : this.policies) {
            policy.close();
        }
    }
}

