/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.oauth;

import android.support.annotation.NonNull;
import android.util.Pair;
import com.ca.mas.core.auth.AuthenticationException;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGRequestBody;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.oauth.OAuthException;
import com.ca.mas.core.oauth.OAuthServerException;
import com.ca.mas.core.oauth.OAuthTokenResponse;
import com.ca.mas.core.policy.exceptions.InvalidClientCredentialException;
import com.ca.mas.core.policy.exceptions.RetryRequestException;
import com.ca.mas.core.request.MAGInternalRequest;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.foundation.MASAuthCredentials;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public class OAuthTokenClient
extends ServerClient {
    private static final int INVALID_CLIENT_CREDENTIALS = 3003201;

    public OAuthTokenClient(MssoContext mssoContext) {
        super(mssoContext);
    }

    public OAuthTokenResponse obtainTokensUsingCredentials(@NonNull MAGInternalRequest request, @NonNull String clientId, @NonNull String clientSecret, boolean requestIdToken) throws OAuthException, OAuthServerException, AuthenticationException {
        OAuthTokenResponse tokenResponse;
        MASAuthCredentials credentials = request.getGrantProvider().getCredentials(this.mssoContext);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        String scope = request.getScope();
        if (scope == null) {
            scope = "openid";
        }
        if (requestIdToken && !scope.contains("msso")) {
            scope = scope + " " + "msso";
        }
        ArrayList<Pair> form = new ArrayList<Pair>();
        List<Pair<String, String>> params = credentials.getParams(this.mssoContext);
        if (params != null) {
            for (Pair<String, String> param : params) {
                form.add(new Pair(param.first, param.second));
            }
        }
        form.add(new Pair((Object)"client_id", (Object)clientId));
        form.add(new Pair((Object)"client_secret", (Object)clientSecret));
        form.add(new Pair((Object)"scope", (Object)scope));
        form.add(new Pair((Object)"grant_type", (Object)credentials.getGrantType()));
        URI uri = this.conf.getTokenUri("msso.url.request_token");
        MAGRequest tokenRequest = new MAGRequest.MAGRequestBuilder(uri).post(MAGRequestBody.urlEncodedFormBody(form)).responseBody(MAGResponseBody.stringBody()).build();
        try {
            tokenResponse = new OAuthTokenResponse(this.obtainServerResponseToPostedForm(tokenRequest));
        }
        catch (MAGException | JSONException e) {
            throw new OAuthException(130201, e);
        }
        catch (MAGServerException e) {
            throw new OAuthServerException(e);
        }
        this.validate(tokenResponse);
        return tokenResponse;
    }

    public OAuthTokenResponse obtainAccessTokenUsingIdToken(@NonNull IdToken idToken, @NonNull String clientId, @NonNull String clientSecret, String scope) throws OAuthException, AuthenticationException, OAuthServerException, RetryRequestException {
        OAuthTokenResponse tokenResponse;
        if (scope == null) {
            scope = "openid phone email";
        }
        ArrayList<Pair> form = new ArrayList<Pair>();
        form.add(new Pair((Object)"assertion", (Object)idToken.getValue()));
        form.add(new Pair((Object)"client_id", (Object)clientId));
        form.add(new Pair((Object)"client_secret", (Object)clientSecret));
        form.add(new Pair((Object)"scope", (Object)scope));
        form.add(new Pair((Object)"grant_type", (Object)idToken.getType()));
        URI uri = this.conf.getTokenUri("msso.url.request_token_sso");
        MAGRequest tokenRequest = new MAGRequest.MAGRequestBuilder(uri).post(MAGRequestBody.urlEncodedFormBody(form)).responseBody(MAGResponseBody.stringBody()).build();
        try {
            tokenResponse = new OAuthTokenResponse(this.obtainServerResponseToPostedForm(tokenRequest));
        }
        catch (MAGException | JSONException e) {
            throw new OAuthException(130201, e);
        }
        catch (MAGServerException e) {
            if (e.getErrorCode() == 3003201) {
                throw new InvalidClientCredentialException(e);
            }
            throw new OAuthServerException(e);
        }
        this.validate(tokenResponse);
        return tokenResponse;
    }

    private void validate(OAuthTokenResponse tokenResponse) throws AuthenticationException, OAuthServerException, OAuthException {
        if (!tokenResponse.isBearer()) {
            throw new OAuthException(130201, "request_token response was token_type other than bearer");
        }
        String accessToken = tokenResponse.getAccessToken();
        if (accessToken == null || accessToken.length() < 1) {
            throw new OAuthException(130201, "request_token response did not include an access_token");
        }
    }

    public OAuthTokenResponse obtainTokenUsingRefreshToken(@NonNull String refreshToken, @NonNull String clientId, @NonNull String clientSecret) throws OAuthException, AuthenticationException, OAuthServerException, RetryRequestException {
        OAuthTokenResponse tokenResponse;
        ArrayList<Pair> form = new ArrayList<Pair>();
        form.add(new Pair((Object)"refresh_token", (Object)refreshToken));
        form.add(new Pair((Object)"client_id", (Object)clientId));
        form.add(new Pair((Object)"client_secret", (Object)clientSecret));
        form.add(new Pair((Object)"grant_type", (Object)"refresh_token"));
        URI uri = this.conf.getTokenUri("msso.url.request_token");
        MAGRequest tokenRequest = new MAGRequest.MAGRequestBuilder(uri).post(MAGRequestBody.urlEncodedFormBody(form)).responseBody(MAGResponseBody.stringBody()).build();
        this.mssoContext.takeRefreshToken();
        try {
            tokenResponse = new OAuthTokenResponse(this.obtainServerResponseToPostedForm(tokenRequest));
        }
        catch (MAGException | JSONException e) {
            throw new OAuthException(130201, e);
        }
        catch (MAGServerException e) {
            if (e.getErrorCode() == 3003201) {
                throw new InvalidClientCredentialException(e);
            }
            throw new OAuthServerException(e);
        }
        this.validate(tokenResponse);
        return tokenResponse;
    }
}

