/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.http;

import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import com.ca.mas.core.http.ContentType;
import com.ca.mas.core.io.Charsets;
import com.ca.mas.foundation.MAS;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MAGRequestBody {
    public abstract ContentType getContentType();

    public abstract long getContentLength();

    public abstract void write(OutputStream var1) throws IOException;

    public Object getContentAsJsonValue() {
        return null;
    }

    public static MAGRequestBody byteArrayBody(final byte[] body) {
        return new MAGRequestBody(){
            private final byte[] content;
            {
                this.content = body;
            }

            @Override
            public ContentType getContentType() {
                return null;
            }

            @Override
            public long getContentLength() {
                return this.content.length;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(this.content);
            }

            @Override
            public Object getContentAsJsonValue() {
                return Base64.encodeToString((byte[])body, (int)11);
            }
        };
    }

    public static MAGRequestBody stringBody(final String body) {
        return new MAGRequestBody(){
            private final byte[] content;
            {
                this.content = body.getBytes(this.getContentType().getCharset());
            }

            @Override
            public ContentType getContentType() {
                return ContentType.TEXT_PLAIN;
            }

            @Override
            public long getContentLength() {
                return this.content.length;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                if (MAS.DEBUG) {
                    Log.d((String)MAS.TAG, (String)String.format("Content: %s", body));
                }
                outputStream.write(this.content);
            }

            @Override
            public Object getContentAsJsonValue() {
                return body;
            }
        };
    }

    public static MAGRequestBody jsonBody(final JSONObject jsonObject) {
        return new MAGRequestBody(){
            private final byte[] content;
            {
                this.content = jsonObject.toString().getBytes(this.getContentType().getCharset());
            }

            @Override
            public ContentType getContentType() {
                return ContentType.APPLICATION_JSON;
            }

            @Override
            public long getContentLength() {
                return this.content.length;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                if (MAS.DEBUG) {
                    try {
                        Log.d((String)MAS.TAG, (String)String.format("Content: %s", jsonObject.toString(4)));
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                outputStream.write(this.content);
            }

            @Override
            public Object getContentAsJsonValue() {
                return jsonObject;
            }
        };
    }

    public static MAGRequestBody urlEncodedFormBody(final List<? extends Pair<String, String>> form) {
        return new MAGRequestBody(){
            private final byte[] content = this.getContent();

            private byte[] getContent() {
                StringBuilder sb = new StringBuilder();
                for (Pair pair : form) {
                    try {
                        String value;
                        String name = URLEncoder.encode((String)pair.first, Charsets.UTF8.name());
                        String string = value = pair.second == null ? null : URLEncoder.encode((String)pair.second, Charsets.UTF8.name());
                        if (sb.length() > 0) {
                            sb.append("&");
                        }
                        sb.append(name);
                        if (value == null) continue;
                        sb.append("=");
                        sb.append(value);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                return sb.toString().getBytes(this.getContentType().getCharset());
            }

            @Override
            public ContentType getContentType() {
                return ContentType.APPLICATION_FORM_URLENCODED;
            }

            @Override
            public long getContentLength() {
                return this.content.length;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                if (MAS.DEBUG) {
                    Log.d((String)MAS.TAG, (String)String.format("Content: %s", new String(this.getContent())));
                }
                outputStream.write(this.content);
            }

            @Override
            public Object getContentAsJsonValue() {
                JSONObject jsonObject = new JSONObject();
                for (Pair pair : form) {
                    if (pair.first == null) continue;
                    try {
                        JSONArray jsonArray = (JSONArray)jsonObject.opt((String)pair.first);
                        if (jsonArray == null) {
                            jsonArray = new JSONArray();
                            jsonObject.put((String)pair.first, (Object)jsonArray);
                        }
                        if (pair.second == null) continue;
                        jsonArray.put(pair.second);
                    }
                    catch (JSONException jSONException) {}
                }
                return jsonObject;
            }
        };
    }
}

