/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.http;

import android.os.Build;
import android.util.Log;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGRequestBody;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.http.SSLSocketFactoryProvider;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASSecurityConfiguration;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocketFactory;

public class MAGHttpClient {
    public <T> MAGResponse<T> execute(MAGRequest request, MASSecurityConfiguration securityConfiguration) throws IOException {
        return this.execute(request, SSLSocketFactoryProvider.getInstance().createSSLSocketFactory(securityConfiguration));
    }

    public <T> MAGResponse<T> execute(MAGRequest request) throws IOException {
        return this.execute(request, SSLSocketFactoryProvider.getInstance().get(request.getURL()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> MAGResponse<T> execute(MAGRequest request, SSLSocketFactory sslSocketFactory) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)request.getURL().openConnection();
        if (MAS.DEBUG) {
            Log.d((String)MAS.TAG, (String)String.format("API Request Url: %s", request.getURL()));
            Log.d((String)MAS.TAG, (String)String.format("API Request Method: %s", request.getMethod()));
        }
        try {
            String responseMessage;
            int responseCode;
            Object sp;
            TokenManager tm;
            Object magIdentifier;
            if (!request.isPublic() && (magIdentifier = (tm = ((StorageProvider)(sp = StorageProvider.getInstance())).getTokenManager()).getMagIdentifier()) != null) {
                urlConnection.setRequestProperty("mag-identifier", (String)magIdentifier);
            }
            this.onConnectionObtained(urlConnection);
            if (request.getConnectionListener() != null) {
                request.getConnectionListener().onObtained(urlConnection);
            }
            if (urlConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslSocketFactory);
            }
            if (ConfigurationManager.getInstance().getConnectionListener() != null) {
                ConfigurationManager.getInstance().getConnectionListener().onObtained(urlConnection);
            }
            urlConnection.setRequestMethod(request.getMethod());
            urlConnection.setDoInput(true);
            for (String key : request.getHeaders().keySet()) {
                if (request.getHeaders().get(key) == null) continue;
                for (String value : request.getHeaders().get(key)) {
                    urlConnection.setRequestProperty(key, value);
                }
            }
            MAGRequestBody body = request.getBody();
            if (body != null) {
                urlConnection.setDoOutput(true);
                if (Build.VERSION.SDK_INT > 19) {
                    if (body.getContentLength() > 0L) {
                        urlConnection.setFixedLengthStreamingMode(body.getContentLength());
                    } else {
                        urlConnection.setChunkedStreamingMode(0);
                    }
                }
                if (body.getContentType() != null) {
                    urlConnection.setRequestProperty("Content-Type", body.getContentType().toString());
                }
                if (request.getConnectionListener() != null) {
                    request.getConnectionListener().onConnected(urlConnection);
                }
                if (ConfigurationManager.getInstance().getConnectionListener() != null) {
                    ConfigurationManager.getInstance().getConnectionListener().onConnected(urlConnection);
                }
                body.write(urlConnection.getOutputStream());
            } else {
                if (request.getConnectionListener() != null) {
                    request.getConnectionListener().onConnected(urlConnection);
                }
                if (ConfigurationManager.getInstance().getConnectionListener() != null) {
                    ConfigurationManager.getInstance().getConnectionListener().onConnected(urlConnection);
                }
            }
            final MAGResponseBody<?> responseBody = request.getResponseBody();
            try {
                responseCode = urlConnection.getResponseCode();
                responseMessage = urlConnection.getResponseMessage();
                if (MAS.DEBUG) {
                    Log.d((String)MAS.TAG, (String)String.format("Response code: %d", responseCode));
                    Log.d((String)MAS.TAG, (String)String.format("Response message: %s", responseMessage));
                }
                responseBody.read(urlConnection);
            }
            catch (SSLHandshakeException e) {
                if (Build.VERSION.SDK_INT < 21) {
                    if (e.getCause() != null && e.getCause() instanceof SSLProtocolException) {
                        if (MAS.DEBUG) {
                            Log.w((String)MAS.TAG, (String)"SSLHandshakeException occurs, setting it to response 204");
                        }
                        responseCode = 204;
                        responseMessage = null;
                    }
                    throw e;
                }
                throw e;
            }
            final Map<String, List<String>> headers = urlConnection.getHeaderFields();
            final int finalResponseCode = responseCode;
            final String finalResponseMessage = responseMessage;
            MAGResponse mAGResponse = new MAGResponse<T>(){

                @Override
                public Map<String, List<String>> getHeaders() {
                    return headers;
                }

                @Override
                public int getResponseCode() {
                    return finalResponseCode;
                }

                @Override
                public String getResponseMessage() {
                    return finalResponseMessage;
                }

                @Override
                public MAGResponseBody<T> getBody() {
                    return responseBody;
                }
            };
            return mAGResponse;
        }
        finally {
            urlConnection.disconnect();
        }
    }

    protected void onConnectionObtained(HttpURLConnection connection) {
    }
}

