/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.datasource;

import android.content.Context;
import com.ca.mas.core.datasource.AccountManagerStoreDataSource;
import com.ca.mas.core.datasource.DataConverter;
import com.ca.mas.core.datasource.DataSourceCallback;
import com.ca.mas.core.security.AccountManagerKeyStorageProvider;
import com.ca.mas.core.security.DefaultEncryptionProvider;
import com.ca.mas.core.storage.StorageResult;
import org.json.JSONObject;

public class SecureAccountManagerStoreDataSource<K, V>
extends AccountManagerStoreDataSource<K, V> {
    private DefaultEncryptionProvider encryptionProvider;

    public SecureAccountManagerStoreDataSource(Context context, JSONObject param, DataConverter converter) {
        super(context, param, converter);
        this.encryptionProvider = new DefaultEncryptionProvider(context, new AccountManagerKeyStorageProvider(context));
    }

    @Override
    public void put(K key, V value) {
        byte[] encryptedValue = this.encryptionProvider.encrypt(this.getValueBytes(value));
        super.put(key, encryptedValue);
    }

    @Override
    public void put(K key, V value, DataSourceCallback callback) {
        byte[] encryptedValue = this.encryptionProvider.encrypt(this.getValueBytes(value));
        super.put(key, encryptedValue, callback);
    }

    @Override
    protected V getData(K key, StorageResult result) {
        Object encryptedValue = result.getData();
        byte[] decryptedValue = this.encryptionProvider.decrypt((byte[])encryptedValue);
        if (this.getConverter() != null) {
            Object converted = this.getConverter().convert(key, decryptedValue);
            return converted;
        }
        return (V)decryptedValue;
    }

    private byte[] getValueBytes(V value) {
        byte[] bytes = null;
        if (value instanceof byte[]) {
            bytes = (byte[])value;
        } else if (value instanceof String) {
            bytes = ((String)value).getBytes();
        }
        return bytes;
    }
}

