/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.context;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.ca.mas.core.EventDispatcher;
import com.ca.mas.core.auth.AuthenticationException;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.context.DeviceIdentifier;
import com.ca.mas.core.context.MssoException;
import com.ca.mas.core.datasource.DataSourceException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.oauth.OAuthClient;
import com.ca.mas.core.policy.PolicyManager;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.exceptions.CertificateExpiredException;
import com.ca.mas.core.policy.exceptions.InvalidClientCredentialException;
import com.ca.mas.core.policy.exceptions.RetryRequestException;
import com.ca.mas.core.registration.RegistrationClient;
import com.ca.mas.core.request.MAGInternalRequest;
import com.ca.mas.core.request.internal.LocalRequest;
import com.ca.mas.core.security.SecureLockException;
import com.ca.mas.core.store.ClientCredentialContainer;
import com.ca.mas.core.store.OAuthTokenContainer;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.core.store.TokenStoreException;
import com.ca.mas.core.token.ClientCredentials;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.token.JWTValidation;
import com.ca.mas.core.token.JWTValidationException;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASConfiguration;
import java.io.IOException;
import java.util.Date;

public class MssoContext {
    private static final int MAX_REQUEST_ATTEMPTS = 4;
    private Context appContext;
    private ConfigurationProvider configurationProvider;
    private PolicyManager policyManager;
    private TokenManager tokenManager;
    private OAuthTokenContainer privateTokens;
    private ClientCredentialContainer clientCredentialTokens;
    private String deviceId;
    private String deviceName;
    private volatile MAGHttpClient magHttpClient;
    private volatile MASAuthCredentials credentials;
    private static final String MSSO_CONTEXT_NOT_INITIALIZED = "MssoContext not initialized, no token manager.";
    protected String containerDescription = null;

    private MssoContext() {
    }

    public static MssoContext newContext() {
        return new MssoContext();
    }

    public boolean isInitialized() {
        return this.configurationProvider != null;
    }

    public void init(Context context) throws MssoException {
        this.appContext = context.getApplicationContext();
        this.configurationProvider = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider();
        if (this.tokenManager == null) {
            this.tokenManager = StorageProvider.getInstance().getTokenManager();
        }
        if (this.privateTokens == null) {
            this.privateTokens = StorageProvider.getInstance().getOAuthTokenContainer();
        }
        if (this.clientCredentialTokens == null) {
            this.clientCredentialTokens = StorageProvider.getInstance().getClientCredentialContainer();
        }
        if (this.deviceId == null) {
            this.deviceId = this.generateDeviceId();
        }
        if (this.deviceName == null) {
            this.deviceName = Build.MODEL;
        }
    }

    public void initPolicyManager() {
        if (this.policyManager == null) {
            this.policyManager = new PolicyManager(this);
        }
        this.policyManager.init(this.appContext);
    }

    public void close() {
        if (this.policyManager != null) {
            this.policyManager.close();
        }
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public boolean isSsoEnabled() {
        Boolean ssoEnabled = (Boolean)this.configurationProvider.getProperty("msso.sso.enabled");
        return ssoEnabled != null && ssoEnabled != false;
    }

    public void clearUserProfile() {
        try {
            this.tokenManager.deleteUserProfile();
        }
        catch (TokenStoreException e) {
            throw new MssoException("Failed to remove User Profile: " + e.getMessage(), e);
        }
    }

    public void clearIdToken() {
        try {
            this.tokenManager.deleteIdToken();
        }
        catch (TokenStoreException e) {
            throw new MssoException("Failed to remove ID token: " + e.getMessage(), e);
        }
    }

    public IdToken getIdToken() {
        return this.isSsoEnabled() && this.tokenManager != null ? this.tokenManager.getIdToken() : null;
    }

    private void setIdToken(IdToken idToken) {
        if (this.isSsoEnabled()) {
            try {
                this.tokenManager.saveIdToken(idToken);
            }
            catch (TokenStoreException e) {
                throw new MssoException("Unable to store ID token: " + e.getMessage(), e);
            }
        }
    }

    public MASAuthCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(MASAuthCredentials credentials) {
        this.credentials = credentials;
    }

    public void clearCredentials() {
        MASAuthCredentials cred = this.getCredentials();
        if (cred != null) {
            cred.clear();
        }
    }

    public boolean isDeviceRegistered() {
        try {
            return this.tokenManager != null && this.tokenManager.isClientCertificateChainAvailable();
        }
        catch (DataSourceException e) {
            if (MAS.DEBUG) {
                Log.w((String)MAS.TAG, (String)("Device not registered: " + e));
            }
            return false;
        }
    }

    public void resetHttpClient() {
        MASConfiguration.SECURITY_CONFIGURATION_RESET.notifyObservers();
    }

    public MAGHttpClient getMAGHttpClient() {
        if (this.magHttpClient == null) {
            this.magHttpClient = new MAGHttpClient();
        }
        return this.magHttpClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onIdTokenAvailable(IdToken idToken) throws JWTValidationException {
        this.clearCredentials();
        String deviceIdentifier = this.tokenManager.getMagIdentifier();
        String clientId = this.getClientId();
        String clientSecret = this.getClientSecret();
        if (idToken.getType().equals("urn:ietf:params:oauth:grant-type:jwt-bearer")) {
            if (!JWTValidation.validateIdToken(idToken, deviceIdentifier, clientId, clientSecret)) throw new JWTValidationException(13101, "JWT Token is not valid");
            this.setIdToken(idToken);
            return;
        } else {
            this.setIdToken(idToken);
        }
    }

    public void onDeviceRegistrationCompleted() {
        this.resetHttpClient();
    }

    public void onAccessTokenAvailable(String accessToken, String refreshToken, long expiresInSec, String grantedScope) {
        if (accessToken != null) {
            this.clearCredentials();
        }
        this.privateTokens.saveAccessToken(accessToken, refreshToken, expiresInSec, grantedScope);
    }

    public void clearAccessToken() {
        this.privateTokens.clear();
    }

    public String getAccessToken() {
        return this.privateTokens.getAccessToken();
    }

    public long getAccessTokenExpiry() {
        return this.privateTokens.getExpiry();
    }

    public String getGrantedScope() {
        return this.privateTokens.getGrantedScope();
    }

    public String takeRefreshToken() {
        return this.privateTokens.takeRefreshToken();
    }

    public String getRefreshToken() {
        return this.privateTokens.getRefreshToken();
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public MAGResponse executeRequest(Bundle extra, MAGRequest request) throws Exception {
        RequestInfo requestInfo = new RequestInfo(this, request, extra);
        MAGInternalRequest internalRequest = requestInfo.getRequest();
        RetryRequestException lastError = null;
        while (requestInfo.getNumAttempts() < 4) {
            block10: {
                try {
                    if (request.isPublic()) {
                        return this.getMAGHttpClient().execute(internalRequest);
                    }
                    this.policyManager.processRequest(requestInfo);
                    MAGResponse response = internalRequest.isLocalRequest() ? ((LocalRequest)internalRequest.getRequest()).send(this) : this.getMAGHttpClient().execute(internalRequest);
                    this.policyManager.processResponse(requestInfo, response);
                    return response;
                }
                catch (MAGServerException e) {
                    if (MAS.DEBUG) {
                        Log.d((String)MAS.TAG, (String)String.format("Server returned x-ca-err %d", e.getErrorCode()));
                    }
                    try {
                        this.rethrow(e);
                    }
                    catch (RetryRequestException rre) {
                        lastError = rre;
                        rre.recover(this);
                        if (MAS.DEBUG) {
                            Log.d((String)MAS.TAG, (String)("Attempting to retry request. " + e.getClass()));
                        }
                    }
                }
                catch (RetryRequestException e) {
                    lastError = e;
                    e.recover(this);
                    if (!MAS.DEBUG) break block10;
                    Log.d((String)MAS.TAG, (String)("Attempting to retry request. " + e.getClass()));
                }
            }
            requestInfo.incrementNumAttempts();
        }
        if (lastError != null) {
            throw lastError;
        }
        throw new IOException("Too many attempts, giving up");
    }

    private void rethrow(MAGServerException e) throws Exception {
        int errorCode = e.getErrorCode();
        String s = Integer.toString(errorCode);
        if (s.endsWith("201")) {
            throw new InvalidClientCredentialException();
        }
        if (s.endsWith("202")) {
            throw new AuthenticationException(e);
        }
        if (s.endsWith("206")) {
            throw new CertificateExpiredException(e);
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(boolean contactServer) throws MssoException {
        EventDispatcher.LOGOUT.notifyObservers();
        if (this.configurationProvider == null) {
            throw new IllegalStateException("MssoContext not initialized, no configuration provider");
        }
        if (this.tokenManager == null) {
            throw new IllegalStateException(MSSO_CONTEXT_NOT_INITIALIZED);
        }
        IdToken idToken = this.getIdToken();
        Exception exception = null;
        byte[] secureIdToken = this.tokenManager.getSecureIdToken();
        if (secureIdToken != null) {
            throw new SecureLockException("The session is currently locked.");
        }
        try {
            block20: {
                block19: {
                    if (this.isSsoEnabled()) {
                        try {
                            this.tokenManager.deleteIdToken();
                        }
                        catch (TokenStoreException e) {
                            exception = e;
                        }
                        try {
                            this.tokenManager.deleteSecureIdToken();
                        }
                        catch (TokenStoreException e) {
                            exception = e;
                        }
                        String clientId = this.getClientId();
                        if (contactServer && idToken != null && clientId != null) {
                            try {
                                new OAuthClient(this).logout(idToken, clientId, this.getClientSecret(), true);
                            }
                            catch (Exception e) {
                                throw new MssoException("Server logout failed:" + e.getMessage(), e);
                            }
                        }
                    }
                    try {
                        this.privateTokens.clear();
                    }
                    catch (DataSourceException e) {
                        if (exception == null) break block19;
                        exception = e;
                    }
                }
                try {
                    this.tokenManager.deleteUserProfile();
                }
                catch (TokenStoreException e) {
                    if (exception == null) break block20;
                    exception = e;
                }
            }
            if (exception != null) {
                throw new MssoException(exception);
            }
        }
        finally {
            this.setCredentials(null);
            this.resetHttpClient();
        }
    }

    public void removeDeviceRegistration() throws MssoException {
        EventDispatcher.DE_REGISTER.notifyObservers();
        if (this.tokenManager == null) {
            throw new IllegalStateException(MSSO_CONTEXT_NOT_INITIALIZED);
        }
        try {
            if (this.isDeviceRegistered()) {
                new RegistrationClient(this).removeDeviceRegistration();
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.w((String)MAS.TAG, (String)("Error in removing device registration details from the server " + e));
            }
            throw new MssoException(e);
        }
        finally {
            this.resetHttpClient();
        }
    }

    public void destroyAllPersistentTokens() throws MssoException {
        if (this.tokenManager == null) {
            throw new IllegalStateException(MSSO_CONTEXT_NOT_INITIALIZED);
        }
        this.setCredentials(null);
        try {
            this.privateTokens.clearAll();
            this.clientCredentialTokens.clearAll();
            this.tokenManager.clearAll();
        }
        catch (DataSourceException | TokenStoreException e) {
            throw new MssoException(e);
        }
        finally {
            this.resetHttpClient();
        }
    }

    public void destroyPersistentTokens() throws MssoException {
        if (this.tokenManager == null) {
            throw new IllegalStateException(MSSO_CONTEXT_NOT_INITIALIZED);
        }
        this.setCredentials(null);
        try {
            this.privateTokens.clear();
            this.clientCredentialTokens.clear();
            this.tokenManager.clear();
        }
        catch (DataSourceException | TokenStoreException e) {
            throw new MssoException(e);
        }
        finally {
            this.resetHttpClient();
        }
    }

    public boolean isLogin() {
        return this.getIdToken() != null || this.getRefreshToken() != null;
    }

    public void setClientCredentials(ClientCredentials clientCredentials) {
        this.clientCredentialTokens.saveClientCredentials(clientCredentials);
    }

    public String getStoredClientId() {
        return this.clientCredentialTokens.getClientId();
    }

    public String getClientId() {
        String clientId = this.clientCredentialTokens.getClientId();
        if (clientId == null) {
            return this.configurationProvider.getClientId();
        }
        return clientId;
    }

    public String getClientSecret() {
        String clientSecret = this.clientCredentialTokens.getClientSecret();
        if (clientSecret == null) {
            clientSecret = this.configurationProvider.getClientSecret();
        }
        return clientSecret;
    }

    public Long getClientExpiration() {
        return this.clientCredentialTokens.getClientExpiration();
    }

    public void clearClientCredentials() {
        this.clientCredentialTokens.clear();
    }

    public boolean isClientCredentialExpired(Long clientExpiration) {
        return clientExpiration != 0L && clientExpiration < new Date().getTime() / 1000L;
    }

    private String generateDeviceId() {
        return new DeviceIdentifier(this.appContext).toString();
    }
}

