/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.context;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.provider.Settings;
import android.util.Log;
import com.ca.mas.core.io.IoUtils;
import com.ca.mas.foundation.MAS;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DeviceIdentifier {
    private String deviceId;

    public DeviceIdentifier(Context context) {
        StringBuilder localDeviceID;
        block14: {
            String containerDescription;
            StringBuilder signatures;
            String androidId;
            String sharedUserIdOrPackageNameHash;
            String DEFAULT;
            block13: {
                PackageManager pkgMgr;
                block12: {
                    localDeviceID = new StringBuilder();
                    sharedUserIdOrPackageNameHash = DEFAULT = "NONE";
                    androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                    androidId = androidId == null ? DEFAULT : androidId;
                    try {
                        String packageName = context.getPackageName();
                        pkgMgr = context.getPackageManager();
                        PackageInfo pkgInfo = pkgMgr.getPackageInfo(packageName, 128);
                        sharedUserIdOrPackageNameHash = pkgInfo.sharedUserId != null ? String.valueOf(pkgInfo.sharedUserId.hashCode()) : String.valueOf(packageName.hashCode());
                    }
                    catch (Exception x) {
                        if (!MAS.DEBUG) break block12;
                        Log.w((String)MAS.TAG, (String)"Unable to get sharedUserIdOrPackageNameHash: ", (Throwable)x);
                    }
                }
                signatures = new StringBuilder(DEFAULT);
                try {
                    Signature[] sigs;
                    pkgMgr = context.getPackageManager();
                    String packageName = context.getPackageName();
                    for (Signature sig : sigs = pkgMgr.getPackageInfo((String)packageName, (int)64).signatures) {
                        if (signatures.toString().equals(DEFAULT)) {
                            signatures = new StringBuilder(String.valueOf(sig.hashCode()));
                            continue;
                        }
                        signatures.append("_");
                        signatures.append(sig.hashCode());
                    }
                }
                catch (Exception noSignature) {
                    if (!MAS.DEBUG) break block13;
                    Log.w((String)MAS.TAG, (String)"Unable to get application signature(s): ", (Throwable)noSignature);
                }
            }
            try {
                containerDescription = this.getContainerDescription(context);
                if (containerDescription.equals("")) {
                    containerDescription = DEFAULT;
                }
            }
            catch (Exception e) {
                containerDescription = DEFAULT;
            }
            localDeviceID.append(androidId);
            localDeviceID.append("__");
            localDeviceID.append(sharedUserIdOrPackageNameHash);
            localDeviceID.append("__");
            localDeviceID.append(containerDescription);
            localDeviceID.append("__");
            localDeviceID.append((CharSequence)signatures);
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] message = String.valueOf(localDeviceID).getBytes("UTF-8");
                md.update(message);
                byte[] mdBytes = md.digest();
                this.deviceId = IoUtils.hexDump(mdBytes);
            }
            catch (UnsupportedEncodingException | IllegalArgumentException | NoSuchAlgorithmException e) {
                if (!MAS.DEBUG) break block14;
                Log.w((String)MAS.TAG, (String)"Error while finding the algorithm to hash or while encoding to utf-8", (Throwable)e);
            }
        }
        if (localDeviceID.length() > 100) {
            localDeviceID = new StringBuilder(localDeviceID.substring(0, 100));
        }
        this.deviceId = String.valueOf(localDeviceID);
    }

    public String getContainerDescription(Context context) {
        String containerDescription;
        block16: {
            containerDescription = null;
            File filesDir = null;
            try {
                filesDir = context.getFilesDir();
                String[] dirs = filesDir.toString().split("\\/");
                if (dirs[1].equals("data")) {
                    if (dirs[2].equals("data")) {
                        if (MAS.DEBUG) {
                            Log.d((String)MAS.TAG, (String)("APP Not in knox container: " + dirs[3]));
                        }
                        containerDescription = "";
                    } else if (dirs[2].equals("data1")) {
                        if (MAS.DEBUG) {
                            Log.d((String)MAS.TAG, (String)("App In knox container #1: " + dirs[3]));
                        }
                        containerDescription = "-knox-1";
                    } else if (dirs[2].equals("user")) {
                        if (MAS.DEBUG) {
                            Log.d((String)MAS.TAG, (String)("APP In knox container #" + dirs[3] + ": " + dirs[4]));
                        }
                        containerDescription = "-knox-" + dirs[3];
                    } else if (MAS.DEBUG) {
                        Log.d((String)MAS.TAG, (String)("APP Knox container status /data/" + dirs[2] + " unknown: " + filesDir));
                    }
                } else if (MAS.DEBUG) {
                    Log.d((String)MAS.TAG, (String)("APP Knox container status /" + dirs[1] + " unknown: " + filesDir));
                }
            }
            catch (Exception noDesc) {
                if (!MAS.DEBUG) break block16;
                Log.w((String)MAS.TAG, (String)("Unable to get container description from " + filesDir + ": " + noDesc));
            }
        }
        if (containerDescription == null) {
            return "";
        }
        return containerDescription;
    }

    public String toString() {
        return this.deviceId;
    }
}

