/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.conf;

import android.net.Uri;
import com.ca.mas.core.cert.CertUtils;
import com.ca.mas.core.cert.PublicKeyHash;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.conf.Server;
import com.ca.mas.core.error.MAGRuntimeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class DefaultConfiguration
implements ConfigurationProvider {
    private final String clientId;
    private final String clientSecret;
    private final String tokenHost;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final JSONObject raw;
    private final Server server;
    private Map<String, String> operationUriSuffixes = new HashMap<String, String>(){
        {
            this.put("msso.url.request_token", "/auth/oauth/v2/token");
            this.put("msso.url.request_token_sso", "/auth/oauth/v2/token");
            this.put("msso.url.register_device", "/connect/device/register");
            this.put("msso.url.renew_device", "/connect/device/renew");
            this.put("msso.url.register_device_client", "/connect/device/register/client");
            this.put("msso.url.resource_owner_logout", "/connect/session/logout");
            this.put("msso.url.remove_device_x509", "/connect/device/remove");
            this.put("msso.url.authorize", "/auth/oauth/v2/authorize");
            this.put("msso.url.enterprise_apps", "/connect/enterprise/browser");
            this.put("msso.url.client_credentials", "/connect/client/initialize");
        }
    };
    private List<X509Certificate> trustedCertificateAnchors = new ArrayList<X509Certificate>();
    private boolean alsoTrustPublicPki = true;
    private Set<PublicKeyHash> trustedCertificatePinnedPublicKeyHashes = new HashSet<PublicKeyHash>();

    public DefaultConfiguration(JSONObject raw, String tokenHost, Integer port, String tokenUriPrefix, String clientId, String clientSecret, String organization) {
        if (tokenHost == null) {
            throw new NullPointerException("tokenHost");
        }
        if (clientId == null) {
            throw new NullPointerException("clientId");
        }
        if (tokenUriPrefix == null) {
            tokenUriPrefix = "";
        }
        this.raw = raw;
        this.clientId = clientId;
        this.clientSecret = clientSecret != null && clientSecret.trim().length() > 0 ? clientSecret : null;
        this.tokenHost = tokenHost;
        this.putProperty("msso.token.uri.prefix", tokenUriPrefix);
        this.putProperty("msso.organization", organization);
        this.putProperty("msso.sso.enabled", true);
        this.putProperty("msso.location.enabled", false);
        this.putProperty("msso.token.port.http", 8080);
        if (port == null) {
            port = 8443;
        }
        this.putProperty("msso.token.port.https", port);
        this.putProperty("msso.cert.rsa.keybits", 2048);
        this.putProperty("msso.response.buffer.enabled", true);
        this.putProperty("msso.response.buffer.maxSize", 0xA00000);
        this.server = new Server(this.getTokenHost(), this.getTokenPort(), this.getPrefix());
    }

    public void setAlsoTrustPublicPki(boolean alsoTrustPublicPki) {
        this.alsoTrustPublicPki = alsoTrustPublicPki;
    }

    public void addTrustedCertificateAnchors(String ... certs) throws MAGRuntimeException {
        for (String cert : certs) {
            try {
                this.trustedCertificateAnchors.add(CertUtils.decodeCertFromPem(cert));
            }
            catch (IOException e) {
                throw new MAGRuntimeException(100203, (Throwable)e);
            }
        }
    }

    public void addTrustedCertificatePinnedPublicKeyHashes(String ... hashes) {
        for (String hash : hashes) {
            this.trustedCertificatePinnedPublicKeyHashes.add(PublicKeyHash.fromHashString(hash, 0));
        }
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getClientScope() {
        return (String)this.getProperty("msso.oauth.scope");
    }

    @Override
    public <T> T getProperty(String propertyName) {
        return (T)this.properties.get(propertyName);
    }

    public <T> void putProperty(String propertyName, T value) {
        this.properties.put(propertyName, value);
    }

    @Override
    public JSONObject getRaw() {
        return this.raw;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public String getTokenHost() {
        return this.tokenHost;
    }

    @Override
    public int getTokenPort() {
        Integer tokenPortHttps = (Integer)this.getProperty("msso.token.port.https");
        if (tokenPortHttps == null) {
            return 8443;
        }
        return tokenPortHttps;
    }

    protected String getTokenUrlSuffix(String operation) {
        String prefix = (String)this.getProperty("msso.token.uri.prefix");
        if (prefix == null) {
            prefix = "";
        }
        String suffix = this.operationUriSuffixes.get(operation);
        return prefix + suffix;
    }

    @Override
    public URI getTokenUri(String operation) {
        if (!operation.startsWith("msso.url.")) {
            return null;
        }
        Integer tokenPortHttps = this.getTokenPort();
        try {
            String suffix = (String)this.getProperty(operation);
            if (suffix != null) {
                if (!DefaultConfiguration.isAbsolute(suffix)) {
                    String prefix = (String)this.getProperty("msso.token.uri.prefix");
                    suffix = prefix == null ? suffix : prefix + suffix;
                }
            } else {
                suffix = this.getTokenUrlSuffix(operation);
            }
            if (suffix == null) {
                return null;
            }
            if (DefaultConfiguration.isAbsolute(suffix)) {
                return new URL(suffix).toURI();
            }
            return new URL("https", this.getTokenHost(), tokenPortHttps, suffix).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new MAGRuntimeException(100204, "Unable to create URL for operation \"" + operation + "\": " + e.getMessage(), e);
        }
    }

    @Override
    public Uri getUserInfoUri() {
        String userInfo = (String)this.getProperty("mas.url.user_info");
        if (userInfo == null) {
            userInfo = "/openid/connect/v1/userinfo";
        }
        return new Uri.Builder().path(userInfo).build();
    }

    @Override
    public URI getUri(String relativePath) {
        Integer tokenPortHttps = (Integer)this.getProperty("msso.token.port.https");
        if (tokenPortHttps == null) {
            tokenPortHttps = 8443;
        }
        String suffix = relativePath;
        try {
            if (relativePath == null) {
                suffix = "";
            }
            if (DefaultConfiguration.isAbsolute(suffix)) {
                return new URL(suffix).toURI();
            }
            return new URL("https", this.getTokenHost(), tokenPortHttps, this.getPrefix() + suffix).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new MAGRuntimeException(100204, "Unable to create URL for operation \"" + relativePath + "\": " + e.getMessage(), e);
        }
    }

    @Override
    public String getPrefix() {
        String prefix = (String)this.getProperty("msso.token.uri.prefix");
        if (prefix == null) {
            return "";
        }
        return prefix;
    }

    private static boolean isAbsolute(String suffix) {
        return suffix.toLowerCase().startsWith("https:") || suffix.toLowerCase().startsWith("http:");
    }

    @Override
    public Collection<X509Certificate> getTrustedCertificateAnchors() {
        return Collections.unmodifiableCollection(this.trustedCertificateAnchors);
    }

    @Override
    public boolean isAlsoTrustPublicPki() {
        return this.alsoTrustPublicPki;
    }

    @Override
    public Collection<PublicKeyHash> getTrustedCertificatePinnedPublicKeyHashes() {
        return Collections.unmodifiableCollection(this.trustedCertificatePinnedPublicKeyHashes);
    }
}

