/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.conf;

import android.content.Context;
import android.util.Log;
import com.ca.mas.core.MobileSsoListener;
import com.ca.mas.core.conf.Config;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.conf.DefaultConfiguration;
import com.ca.mas.core.conf.Server;
import com.ca.mas.core.error.MAGRuntimeException;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.oauth.GrantProvider;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.foundation.MAS;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigurationManager {
    private static final String CONNECTED_GATEWAY_CONFIG = "connected_gateway.json";
    private ConfigurationProvider connectedGatewayConfigurationProvider = null;
    private Context appContext;
    private List<Config> appConfigs;
    private String configurationFileName = null;
    private boolean enablePKCE = true;
    private MAGRequest.MAGConnectionListener connectionListener;
    private MobileSsoListener mobileSsoListener;
    private GrantProvider defaultGrantProvider = GrantProvider.PASSWORD;
    private static ConfigurationManager instance = new ConfigurationManager();
    private List<ConfigurationListener> configurationListeners = new ArrayList<ConfigurationListener>();
    private int certificateAdvancedRenewTimeframe = 30;

    private ConfigurationManager() {
        this.configurationListeners.add(new ClientChangeListener());
    }

    public static ConfigurationManager getInstance() {
        return instance;
    }

    public Context getContext() {
        return this.appContext;
    }

    public void enablePKCE(boolean enablePKCE) {
        this.enablePKCE = enablePKCE;
    }

    public boolean isPKCEEnabled() {
        return this.enablePKCE;
    }

    public void reset() {
        this.connectedGatewayConfigurationProvider = null;
    }

    public void init(Context context) {
        this.appContext = context.getApplicationContext();
    }

    public void setAppConfigs(List<Config> appConfigs) {
        this.appConfigs = appConfigs;
    }

    public Server getConnectedGateway() {
        this.load();
        if (this.connectedGatewayConfigurationProvider != null) {
            return this.connectedGatewayConfigurationProvider.getServer();
        }
        throw new IllegalStateException("Gateway configuration should be configured.");
    }

    public JSONObject getConnectedGatewayConfig() {
        this.load();
        return this.connectedGatewayConfigurationProvider.getRaw();
    }

    public ConfigurationProvider getConnectedGatewayConfigurationProvider() {
        this.load();
        return this.connectedGatewayConfigurationProvider;
    }

    private void store(JSONObject config) {
        OutputStreamWriter writer = null;
        try {
            Context appContext = this.appContext;
            writer = new OutputStreamWriter(appContext.openFileOutput(CONNECTED_GATEWAY_CONFIG, 0));
            writer.write(config.toString());
            writer.flush();
        }
        catch (IOException e) {
            throw new MAGRuntimeException(100202, (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void load() {
        if (this.connectedGatewayConfigurationProvider != null) {
            return;
        }
        StringBuilder jsonConfig = new StringBuilder();
        try (FileInputStream is = this.appContext.openFileInput(CONNECTED_GATEWAY_CONFIG);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));){
            String str;
            while ((str = br.readLine()) != null) {
                jsonConfig.append(str);
            }
            this.connectedGatewayConfigurationProvider = this.create(new JSONObject(jsonConfig.toString()));
        }
        catch (IOException | JSONException e) {
            this.activateDefault();
        }
    }

    public void activateDefault() {
        JSONObject jsonObject = this.getConfig(this.getConfigurationFileName());
        this.activate(jsonObject);
    }

    public void activate(JSONObject jsonObject) {
        try {
            this.connectedGatewayConfigurationProvider = this.create(jsonObject);
            Context appContext = this.appContext;
            if (MAS.DEBUG) {
                Log.d((String)MAS.TAG, (String)String.format("Activate configuration: %s", jsonObject.toString(4)));
            }
            for (ConfigurationListener c : this.configurationListeners) {
                c.onUpdated(appContext, this.connectedGatewayConfigurationProvider);
            }
        }
        catch (JSONException e) {
            throw new MAGRuntimeException(100203, (Throwable)e);
        }
        this.store(jsonObject);
    }

    private JSONObject getConfig(String filename) {
        InputStream is = null;
        try {
            Context appContext = this.appContext;
            is = appContext.getAssets().open(filename);
            JSONObject jSONObject = this.getConfig(is);
            return jSONObject;
        }
        catch (IOException e) {
            throw new MAGRuntimeException(100201, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public JSONObject getConfig(InputStream is) {
        StringBuilder jsonConfig = new StringBuilder();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((str = in.readLine()) != null) {
                jsonConfig.append(str);
            }
            JSONObject jSONObject = new JSONObject(jsonConfig.toString());
            return jSONObject;
        }
        catch (IOException e) {
            throw new MAGRuntimeException(100201, (Throwable)e);
        }
        catch (JSONException e) {
            throw new MAGRuntimeException(100002, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ConfigurationProvider create(JSONObject jsonObject) throws JSONException {
        String tokenHost = (String)this.getValue(Config.HOSTNAME, jsonObject);
        String tokenUriPrefix = (String)this.getValue(Config.PREFIX, jsonObject);
        Integer port = (Integer)this.getValue(Config.PORT, jsonObject);
        String clientId = (String)this.getValue(Config.CLIENT_KEY, jsonObject);
        String clientSecret = (String)this.getValue(Config.CLIENT_SECRET, jsonObject);
        String organization = (String)this.getValue(Config.ORGANIZATION, jsonObject);
        DefaultConfiguration conf = new DefaultConfiguration(jsonObject, tokenHost, port, tokenUriPrefix, clientId, clientSecret, organization);
        Config[] attrs = Config.values;
        for (Config attr : attrs) {
            if (attr == Config.SERVER_CERTS) {
                List trustedCerts = (List)this.getValue(Config.SERVER_CERTS, jsonObject);
                if (trustedCerts == null || trustedCerts.size() <= 0) continue;
                conf.addTrustedCertificateAnchors(trustedCerts.toArray(new String[trustedCerts.size()]));
                continue;
            }
            if (attr == Config.TRUSTED_CERT_PINNED_PUBLIC_KEY_HASHES) {
                List trustedPins = (List)this.getValue(Config.TRUSTED_CERT_PINNED_PUBLIC_KEY_HASHES, jsonObject);
                if (trustedPins == null || trustedPins.size() <= 0) continue;
                conf.addTrustedCertificatePinnedPublicKeyHashes(trustedPins.toArray(new String[trustedPins.size()]));
                continue;
            }
            if (attr == Config.TRUSTED_PUBLIC_PKI) {
                conf.setAlsoTrustPublicPki((Boolean)this.getValue(Config.TRUSTED_PUBLIC_PKI, jsonObject, Boolean.FALSE));
                continue;
            }
            conf.putProperty(attr.key, this.getValue(attr, jsonObject));
        }
        if (this.appConfigs != null) {
            for (Config appConfig : this.appConfigs) {
                conf.putProperty(appConfig.key, this.getValue(appConfig, jsonObject));
            }
        }
        return conf;
    }

    private <T> T getValue(Config attr, JSONObject jsonObject) throws JSONException {
        return this.getValue(attr, jsonObject, null);
    }

    private <T> T getValue(Config attr, JSONObject jsonObject, Object def) throws JSONException {
        Object value = ConfigurationManager.getValue(attr.path, attr.mandatory, jsonObject);
        if (value == null) {
            return (T)def;
        }
        if (!(attr.type.isAssignableFrom(value.getClass()) || value instanceof JSONArray && attr.type.isAssignableFrom(List.class) || value instanceof JSONObject && attr.type.isAssignableFrom(String.class))) {
            throw new MAGRuntimeException(100203, "Invalid value for attribute " + attr.path);
        }
        if (value instanceof String) {
            if (((String)value).trim().length() != 0) {
                return (T)value;
            }
            if (attr.mandatory) {
                throw new MAGRuntimeException(100203, "Invalid value for attribute " + attr.path);
            }
        } else if (value instanceof JSONArray) {
            ArrayList<String> list = new ArrayList<String>();
            JSONArray jsonArray = (JSONArray)value;
            for (int i = 0; i < jsonArray.length(); ++i) {
                String v = null;
                Object a = jsonArray.get(i);
                if (a instanceof JSONArray) {
                    v = ((JSONArray)a).join("\n");
                    v = v.replace("\"", "");
                } else {
                    v = a.toString();
                }
                list.add(v);
            }
            return (T)list;
        }
        return (T)value;
    }

    private static Object getValue(String path, boolean mandatory, Object parent) throws JSONException {
        if (parent == null) {
            return null;
        }
        int d = path.indexOf(".");
        if (d > 0) {
            String prefix = path.substring(0, d);
            if (parent instanceof JSONArray) {
                int index = Integer.parseInt(prefix);
                JSONArray array = (JSONArray)parent;
                return ConfigurationManager.getValue(path.substring(d + 1), mandatory, array.get(index));
            }
            JSONObject jsonObject = (JSONObject)parent;
            Object nested = null;
            nested = mandatory ? jsonObject.get(prefix) : jsonObject.opt(prefix);
            return ConfigurationManager.getValue(path.substring(d + 1), mandatory, nested);
        }
        JSONObject jsonObject = (JSONObject)parent;
        if (mandatory) {
            return jsonObject.get(path);
        }
        return jsonObject.opt(path);
    }

    public String getConfigurationFileName() {
        if (this.configurationFileName == null) {
            return "msso_config.json";
        }
        return this.configurationFileName;
    }

    public void setConfigurationFileName(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public MAGRequest.MAGConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public void setConnectionListener(MAGRequest.MAGConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public MobileSsoListener getMobileSsoListener() {
        return this.mobileSsoListener;
    }

    public void setMobileSsoListener(MobileSsoListener mobileSsoListener) {
        this.mobileSsoListener = mobileSsoListener;
    }

    public GrantProvider getDefaultGrantProvider() {
        return this.defaultGrantProvider;
    }

    public void setDefaultGrantProvider(GrantProvider defaultGrantProvider) {
        this.defaultGrantProvider = defaultGrantProvider;
    }

    public int getCertificateAdvancedRenewTimeframe() {
        return this.certificateAdvancedRenewTimeframe;
    }

    public void setCertificateAdvancedRenewTimeframe(int certificateAdvancedRenewTimeframe) {
        this.certificateAdvancedRenewTimeframe = certificateAdvancedRenewTimeframe;
    }

    private static interface ConfigurationListener {
        public void onUpdated(Context var1, ConfigurationProvider var2);
    }

    private static class ClientChangeListener
    implements ConfigurationListener {
        private static final String TAG = ClientChangeListener.class.getCanonicalName();

        private ClientChangeListener() {
        }

        @Override
        public void onUpdated(Context context, ConfigurationProvider provider) {
            StorageProvider.getInstance().reset();
            if (!StorageProvider.getInstance().hasValidStore()) {
                Log.w((String)TAG, (String)"Failed to access the secure device storage, please verify the storage configuration, and make sure the device has Secure lock screen setup.");
                return;
            }
            String masterClientId = StorageProvider.getInstance().getClientCredentialContainer().getMasterClientId();
            if (masterClientId == null || !masterClientId.equals(provider.getClientId())) {
                StorageProvider.getInstance().getClientCredentialContainer().clear();
                StorageProvider.getInstance().getOAuthTokenContainer().clear();
            }
        }
    }
}

