/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.cert;

import android.util.Base64;
import android.util.Log;
import com.ca.mas.foundation.MAS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import sun.security.pkcs.PKCS10;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;

public class CertUtils {
    private static final String PEM_CERT_BEGIN_MARKER = "-----BEGIN CERTIFICATE-----";
    private static final String PEM_CERT_END_MARKER = "-----END CERTIFICATE-----";

    public static X509Certificate decodeCertFromPem(String certificateText) throws IOException {
        String base64Certificate;
        int startIndex = certificateText.indexOf(PEM_CERT_BEGIN_MARKER);
        int endIndex = certificateText.indexOf(PEM_CERT_END_MARKER);
        if (startIndex < 0 || endIndex < startIndex) {
            if (endIndex >= 0) {
                throw new IOException("Begin PEM marker present, but end marker missing");
            }
            base64Certificate = certificateText;
        } else {
            base64Certificate = certificateText.substring(startIndex + PEM_CERT_BEGIN_MARKER.length(), endIndex);
        }
        base64Certificate = base64Certificate.replace("\\/", "/");
        byte[] bytes = Base64.decode((String)base64Certificate, (int)0);
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)("Unable to decode public certificate, error: " + e + " for cert " + certificateText), (Throwable)e);
            }
            throw new IOException(e);
        }
    }

    public static byte[] generateCertificateSigningRequest(String commonName, String deviceId, String deviceName, String organization, PublicKey publicKey, PrivateKey privateKey) throws CertificateException {
        try {
            PKCS10 pkcs10 = new PKCS10(publicKey);
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            X500Name x500Name = new X500Name("cn=" + commonName + ", ou=" + deviceId + ", dc=" + deviceName + ", o=" + organization);
            pkcs10.encodeAndSign(new X500Signer(signature, x500Name));
            return pkcs10.getEncoded();
        }
        catch (Exception t) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)("Unable to generate certificate signing request: " + t), (Throwable)t);
            }
            throw new CertificateException("Unable to generate certificate signing request: " + t);
        }
    }

    private static X509Certificate[] toX509CertArray(Collection<? extends Certificate> certs) {
        ArrayList<X509Certificate> x509Certs = new ArrayList<X509Certificate>();
        for (Certificate certificate : certs) {
            x509Certs.add((X509Certificate)certificate);
        }
        return x509Certs.toArray(new X509Certificate[x509Certs.size()]);
    }

    public static X509Certificate[] decodeCertificateChain(byte[] chainBytes) {
        try {
            return CertUtils.toX509CertArray(CertificateFactory.getInstance("X.509").generateCertificates(new ByteArrayInputStream(chainBytes)));
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)MAS.TAG, (String)("Unable to decode certificate chain: " + e), (Throwable)e);
            }
            throw new IllegalArgumentException(e);
        }
    }

    private CertUtils() {
    }
}

