/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.auth;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.util.Log;
import android.view.View;
import com.ca.mas.core.auth.PollingRenderer;
import com.ca.mas.foundation.MAS;
import java.io.IOException;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class NFCRenderer
extends PollingRenderer {
    public static final int NFC_ERR = 100;
    public static final int BLUETOOTH_ERR = 101;
    public static final int BLUETOOTH_CONN_ERR = 102;
    public static final String UUID = "uuid";
    public static final String PROVIDER_URL = "provider_url";
    public static final String ADDRESS = "address";
    private ListenerThread listener = null;
    private UUID uuid = null;
    private NfcAdapter adapter = null;
    private String address = null;

    @Override
    public View render() {
        return null;
    }

    @Override
    public void onRenderCompleted() {
        block7: {
            this.adapter = NfcAdapter.getDefaultAdapter((Context)this.context);
            if (this.adapter == null) {
                this.onError(100, "NFC is not available", null);
                return;
            }
            if (!this.adapter.isEnabled()) {
                this.onError(100, "NFC is not enabled", null);
                return;
            }
            this.uuid = java.util.UUID.randomUUID();
            try {
                this.listener = new ListenerThread();
                this.listener.start();
            }
            catch (Exception e) {
                if (MAS.DEBUG) {
                    Log.w((String)MAS.TAG, (String)"Failed to start Bluetooth Service, will use polling for NFC notification", (Throwable)e);
                }
                this.onError(101, "Unable to start Bluetooth Service", e);
            }
            this.adapter.setOnNdefPushCompleteCallback(new NfcAdapter.OnNdefPushCompleteCallback(){

                public void onNdefPushComplete(NfcEvent event) {
                    NFCRenderer.this.poll();
                }
            }, (Activity)this.context, new Activity[0]);
            final JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(UUID, (Object)this.uuid.toString());
                jsonObject.put(PROVIDER_URL, (Object)this.provider.getUrl().toString());
                jsonObject.put(ADDRESS, (Object)this.address);
                this.adapter.setNdefPushMessageCallback(new NfcAdapter.CreateNdefMessageCallback(){

                    public NdefMessage createNdefMessage(NfcEvent event) {
                        return new NdefMessage(new NdefRecord[]{NdefRecord.createMime((String)"application/vnd.com.ca.mas.core.beam", (byte[])jsonObject.toString().getBytes())});
                    }
                }, (Activity)this.context, new Activity[0]);
            }
            catch (JSONException e) {
                if (!MAS.DEBUG) break block7;
                Log.e((String)MAS.TAG, (String)"Failed to set NFC Push Message Callback", (Throwable)e);
            }
        }
        super.onRenderCompleted();
    }

    @Override
    public void onError(int code, String message, Exception e) {
    }

    @Override
    public void close() {
        super.close();
        if (this.listener != null) {
            this.listener.cancel();
        }
        if (this.adapter != null) {
            this.adapter.setNdefPushMessageCallback(null, (Activity)this.context, new Activity[0]);
        }
    }

    @Override
    protected boolean startPollingOnStartup() {
        return false;
    }

    private class ListenerThread
    extends Thread {
        private BluetoothServerSocket serverSocket;

        public ListenerThread() throws Exception {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter == null) {
                throw new IllegalStateException("Unable to acquire BluetoothAdapter");
            }
            adapter.cancelDiscovery();
            this.serverSocket = adapter.listenUsingInsecureRfcommWithServiceRecord("BluetoothRenderer", NFCRenderer.this.uuid);
            NFCRenderer.this.address = adapter.getAddress();
        }

        @Override
        public void run() {
            BluetoothSocket socket = null;
            try {
                if (this.serverSocket != null) {
                    socket = this.serverSocket.accept();
                    NFCRenderer.this.proceed();
                }
            }
            catch (IOException e) {
            }
            finally {
                block21: {
                    block20: {
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (IOException e) {
                                if (!MAS.DEBUG) break block20;
                                Log.d((String)MAS.TAG, (String)("Failed to close BlueTooth Socket: " + e.getMessage()));
                            }
                        }
                    }
                    if (this.serverSocket != null) {
                        try {
                            this.serverSocket.close();
                        }
                        catch (IOException e) {
                            if (!MAS.DEBUG) break block21;
                            Log.d((String)MAS.TAG, (String)("Failed to close BlueTooth ServerSocket: " + e.getMessage()));
                        }
                    }
                }
            }
        }

        public void cancel() {
            block3: {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException e) {
                        if (!MAS.DEBUG) break block3;
                        Log.d((String)MAS.TAG, (String)("Failed to close BlueTooth ServerSocket: " + e.getMessage()));
                    }
                }
            }
        }
    }
}

