/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.auth;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.view.View;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.service.MssoService;
import com.ca.mas.core.service.Provider;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASAuthCredentialsAuthorizationCode;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public abstract class AuthRenderer {
    public static final int AUTH_CODE_ERR = 1;
    protected Context context;
    protected Provider provider;
    protected long requestId;

    public boolean init(Context context, Provider provider) {
        this.context = context;
        this.provider = provider;
        return true;
    }

    public String getId() {
        return "qrcode";
    }

    public abstract View render();

    public abstract void onRenderCompleted();

    protected abstract void onError(int var1, String var2, Exception var3);

    public abstract void close();

    protected synchronized void proceed() {
        try {
            MAGRequest request = new MAGRequest.MAGRequestBuilder(new URL(this.provider.getPollUrl())).responseBody(MAGResponseBody.jsonBody()).build();
            MAGHttpClient httpClient = new MAGHttpClient(){

                @Override
                protected void onConnectionObtained(HttpURLConnection connection) {
                    super.onConnectionObtained(connection);
                    TokenManager tokenManager = StorageProvider.getInstance().getTokenManager();
                    String magIdentifier = tokenManager.getMagIdentifier();
                    if (magIdentifier != null) {
                        connection.setRequestProperty("mag-identifier", magIdentifier);
                    }
                }
            };
            MAGResponse response = httpClient.execute(request);
            if (200 == response.getResponseCode()) {
                JSONObject json;
                if (response.getBody() != null && (json = (JSONObject)response.getBody().getContent()) != null) {
                    String code = json.getString("code");
                    String state = json.optString("state");
                    if (code != null && code.length() > 0) {
                        this.sendCredentialsIntent(new MASAuthCredentialsAuthorizationCode(code, state));
                        this.onAuthCodeReceived(code);
                    }
                }
            } else {
                String msg = "Session Polling error.";
                if (response.getBody() != null) {
                    msg = new String(response.getBody().getRawContent());
                }
                this.onError(1, msg, null);
            }
        }
        catch (Exception e) {
            this.onError(1, e.getMessage(), e);
        }
    }

    public void sendCredentialsIntent(MASAuthCredentials credentials) {
        Intent intent = new Intent("com.ca.mas.core.service.action.CREDENTIALS_OBTAINED", null, this.context, MssoService.class);
        intent.putExtra("com.ca.mas.core.service.req.extra.requestId", this.requestId);
        intent.putExtra("com.ca.mas.core.service.req.extra.credentials", (Parcelable)credentials);
        this.context.startService(intent);
    }

    protected abstract void onAuthCodeReceived(String var1);
}

