/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core;

import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.util.Log;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.error.TargetApiException;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.service.MssoClient;
import com.ca.mas.foundation.MAS;

public abstract class MAGResultReceiver<T>
extends ResultReceiver {
    public MAGResultReceiver(Handler handler) {
        super(handler);
    }

    public MAGResultReceiver() {
        super(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onReceiveResult(int resultCode, Bundle resultData) {
        try {
            switch (resultCode) {
                case 0: {
                    long requestId = resultData.getLong("com.ca.mas.core.service.result.requestId");
                    if (requestId == -1L || requestId == 0L) {
                        this.onError(new MAGError(new IllegalStateException("Received result included an invalid request ID")));
                        return;
                    }
                    MAGResponse response = MssoClient.takeMAGResponse(requestId);
                    if (response == null) return;
                    int responseCode = response.getResponseCode();
                    if (responseCode < 200 || responseCode >= 300) {
                        this.onError(new MAGError(response.getResponseMessage(), new TargetApiException(response)));
                        return;
                    }
                    this.onSuccess(response);
                    return;
                }
                case 4: {
                    this.onRequestCancelled(resultData);
                    return;
                }
                default: {
                    MAGError error = (MAGError)resultData.getSerializable("com.ca.mas.core.service.result.error");
                    if (error == null) return;
                    if (MAS.DEBUG) {
                        Log.d((String)MAS.TAG, (String)("Error response with: " + error.getMessage()), (Throwable)error);
                    }
                    error.setResultCode(resultCode);
                    this.onError(error);
                }
            }
            return;
        }
        catch (Throwable e) {
            if (!MAS.DEBUG) return;
            Log.e((String)MAS.TAG, (String)"Error handling response.", (Throwable)e);
        }
    }

    public abstract void onSuccess(MAGResponse<T> var1);

    public abstract void onError(MAGError var1);

    public abstract void onRequestCancelled(Bundle var1);
}

