/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.tasks.gw7;

import com.ca.apim.gateway.cagatewayconfig.tasks.gw7.GW7Builder;
import com.ca.apim.gateway.cagatewayconfig.tasks.gw7.PackageBuildException;
import com.ca.apim.gateway.cagatewayconfig.util.bundle.DependencyBundlesProcessor;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

class Packager {
    private static final String DIRECTORY_OPT_DOCKER_RC_D = "/opt/docker/rc.d/";
    private static final String DIRECTORY_GATEWAY_MODULES = "/opt/SecureSpan/Gateway/runtime/modules/";
    private static final String BUNDLE_FILE_EXTENSION = "bundle";
    private static final String REQ_BUNDLE_FILE_EXTENSION = "req.bundle";
    private final GW7Builder gw7Builder;
    private final FileUtils fileUtils;
    private final DependencyBundlesProcessor dependencyBundlesProcessor;

    Packager(FileUtils fileUtils, GW7Builder gw7Builder, DependencyBundlesProcessor dependencyBundlesProcessor) {
        this.fileUtils = fileUtils;
        this.gw7Builder = gw7Builder;
        this.dependencyBundlesProcessor = dependencyBundlesProcessor;
    }

    void buildPackage(File gw7File, File bundle, LinkedList<File> dependencyBundles, Set<File> containerApplicationDependencies, Set<File> modularAssertionDependencies, Set<File> customAssertionDependencies) {
        int numBundles = dependencyBundles.size() + 2;
        Set<GW7Builder.PackageFile> packageFiles = Stream.of(this.dependencyBundles(dependencyBundles, bundle.getParentFile().getPath(), numBundles), this.deploymentBundle(bundle, dependencyBundles.size(), numBundles), this.applyEnvironmentScript(), this.fileDependencies(containerApplicationDependencies, "/opt/docker/rc.d/apply-environment/"), this.fileDependencies(modularAssertionDependencies, "/opt/SecureSpan/Gateway/runtime/modules/assertions/"), this.fileDependencies(customAssertionDependencies, "/opt/SecureSpan/Gateway/runtime/modules/lib/")).flatMap(Function.identity()).collect(Collectors.toSet());
        this.gw7Builder.buildPackage(this.fileUtils.getOutputStream(gw7File), packageFiles);
    }

    private String convertToReqBundle(String bundleFile) {
        return bundleFile.substring(0, bundleFile.length() - BUNDLE_FILE_EXTENSION.length()).concat(REQ_BUNDLE_FILE_EXTENSION);
    }

    private String getFileCounter(int numBundles, int currentBundleNumber) {
        int paddingLevel = numBundles / 10;
        String format = "%0" + numBundles / 10 + "d";
        return paddingLevel > 0 ? String.format(format, currentBundleNumber) : String.valueOf(currentBundleNumber);
    }

    private Stream<GW7Builder.PackageFile> dependencyBundles(LinkedList<File> dependencyBundles, String bundleFolderPath, int numBundles) {
        AtomicInteger dependencyBundleCounter = new AtomicInteger(1);
        dependencyBundles = this.dependencyBundlesProcessor.process(dependencyBundles, bundleFolderPath);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(dependencyBundles.descendingIterator(), 16), false).map(f -> new GW7Builder.PackageFile("/opt/docker/rc.d/bundle/templatized/_" + this.getFileCounter(numBundles, dependencyBundleCounter.getAndIncrement()) + "_" + this.convertToReqBundle(f.getName()), f.length(), () -> this.fileUtils.getInputStream(f)));
    }

    @NotNull
    private Stream<GW7Builder.PackageFile> deploymentBundle(File deploymentBundleFile, int numDependencyBundles, int numBundles) {
        return Stream.of(new GW7Builder.PackageFile("/opt/docker/rc.d/bundle/templatized/_" + this.getFileCounter(numBundles, numDependencyBundles + 1) + "_" + this.convertToReqBundle(deploymentBundleFile.getName()), deploymentBundleFile.length(), () -> this.fileUtils.getInputStream(deploymentBundleFile)));
    }

    private Stream<GW7Builder.PackageFile> applyEnvironmentScript() {
        byte[] applyEnvBytes = this.getResourceBytes("/scripts/apply-environment.sh");
        return Stream.builder().add(new GW7Builder.PackageFile("/opt/docker/rc.d/apply-environment.sh", applyEnvBytes.length, () -> new ByteArrayInputStream(applyEnvBytes), true)).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getResourceBytes(String resourcePath) {
        try (InputStream applyEnvStream = this.getClass().getResourceAsStream(resourcePath);){
            if (applyEnvStream == null) {
                throw new PackageBuildException("Error loading " + resourcePath + " bytes. Could not find the resource.");
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)applyEnvStream);
            return byArray;
        }
        catch (IOException e) {
            throw new PackageBuildException("Error loading " + resourcePath + " bytes: " + e.getMessage(), e);
        }
    }

    @NotNull
    private Stream<GW7Builder.PackageFile> fileDependencies(Set<File> files, String path) {
        return files.stream().map(f -> new GW7Builder.PackageFile(path + f.getName(), f.length(), () -> this.fileUtils.getInputStream(f)));
    }
}

