/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.tasks.gw7;

import com.ca.apim.gateway.cagatewayconfig.ProjectDependencyUtils;
import com.ca.apim.gateway.cagatewayconfig.tasks.gw7.GW7Builder;
import com.ca.apim.gateway.cagatewayconfig.tasks.gw7.Packager;
import com.ca.apim.gateway.cagatewayconfig.util.bundle.DependencyBundlesProcessor;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionRegistry;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.collections4.SetUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class PackageTask
extends DefaultTask {
    private ConfigurableFileCollection dependencyBundles;
    private ConfigurableFileCollection containerApplicationDependencies;
    private ConfigurableFileCollection dependencyModularAssertions;
    private ConfigurableFileCollection dependencyCustomAssertions;
    private RegularFileProperty into = this.newOutputFile();
    private RegularFileProperty bundle = this.newInputFile();
    private final FileUtils fileUtils;
    private final GW7Builder gw7Builder;
    private final DependencyBundlesProcessor dependencyBundlesProcessor;

    @Inject
    public PackageTask() {
        this(FileUtils.INSTANCE, GW7Builder.INSTANCE);
    }

    PackageTask(FileUtils fileUtils, GW7Builder gw7Builder) {
        this.dependencyBundles = this.getProject().files(new Object[0]);
        this.containerApplicationDependencies = this.getProject().files(new Object[0]);
        this.dependencyModularAssertions = this.getProject().files(new Object[0]);
        this.dependencyCustomAssertions = this.getProject().files(new Object[0]);
        this.fileUtils = fileUtils;
        this.gw7Builder = gw7Builder;
        this.dependencyBundlesProcessor = (DependencyBundlesProcessor)InjectionRegistry.getInstance(DependencyBundlesProcessor.class);
    }

    @InputFile
    public RegularFileProperty getBundle() {
        return this.bundle;
    }

    @InputFiles
    public ConfigurableFileCollection getDependencyBundles() {
        return this.dependencyBundles;
    }

    @InputFiles
    public ConfigurableFileCollection getContainerApplicationDependencies() {
        return this.containerApplicationDependencies;
    }

    @InputFiles
    public ConfigurableFileCollection getDependencyModularAssertions() {
        return this.dependencyModularAssertions;
    }

    @InputFiles
    public ConfigurableFileCollection getDependencyCustomAssertions() {
        return this.dependencyCustomAssertions;
    }

    @OutputFile
    public RegularFileProperty getInto() {
        return this.into;
    }

    @TaskAction
    public void perform() {
        Packager packager = new Packager(this.fileUtils, this.gw7Builder, this.dependencyBundlesProcessor);
        Set bundleDependencies = this.dependencyBundles.getAsFileTree().getFiles();
        packager.buildPackage((File)this.into.getAsFile().get(), (File)this.bundle.getAsFile().get(), ProjectDependencyUtils.filterBundleFiles(bundleDependencies), this.containerApplicationDependencies.getFiles(), (Set<File>)SetUtils.union((Set)this.dependencyModularAssertions.getFiles(), ProjectDependencyUtils.filterModularAssertionFiles(bundleDependencies)), (Set<File>)SetUtils.union((Set)this.dependencyCustomAssertions.getFiles(), ProjectDependencyUtils.filterJarFiles(bundleDependencies)));
    }
}

