/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig;

import com.ca.apim.gateway.cagatewayconfig.BundleFileBuilder;
import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.beans.DependentBundle;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class BuildDeploymentBundleTask
extends DefaultTask {
    private DirectoryProperty from;
    private DirectoryProperty into = this.newOutputDirectory();
    private ConfigurableFileCollection dependencies;
    private Property<String> targetFolderPath;

    @Inject
    public BuildDeploymentBundleTask() {
        this.from = this.newInputDirectory();
        this.targetFolderPath = this.getProject().getObjects().property(String.class);
        this.dependencies = this.getProject().files(new Object[0]);
    }

    @InputDirectory
    @Optional
    public DirectoryProperty getFrom() {
        return this.from;
    }

    @OutputDirectory
    public DirectoryProperty getInto() {
        return this.into;
    }

    @Input
    @Optional
    public Property<String> getTargetFolderPath() {
        return this.targetFolderPath;
    }

    @InputFiles
    public ConfigurableFileCollection getDependencies() {
        return this.dependencies;
    }

    @TaskAction
    public void perform() {
        BundleFileBuilder bundleFileBuilder = (BundleFileBuilder)InjectionRegistry.getInjector().getInstance(BundleFileBuilder.class);
        ProjectInfo projectInfo = new ProjectInfo(this.getProject().getName(), this.getProject().getGroup().toString(), this.getProject().getVersion().toString(), null);
        if (this.targetFolderPath.isPresent()) {
            projectInfo.setTargetFolderPath((String)this.targetFolderPath.get());
        }
        List<DependentBundle> dependentBundles = this.getDependentBundles(this.dependencies.getFiles());
        bundleFileBuilder.buildBundle(this.from.isPresent() ? (File)this.from.getAsFile().get() : null, (File)this.into.getAsFile().get(), dependentBundles, projectInfo);
    }

    private List<DependentBundle> getDependentBundles(Set<File> files) {
        ArrayList<DependentBundle> dependentBundles = new ArrayList<DependentBundle>();
        ConfigurationContainer configurations = this.getProject().getConfigurations();
        Configuration configuration = configurations.getByName("bundle");
        DependencySet dependencySet = configuration.getDependencies();
        files.forEach(file -> {
            if (file.getName().endsWith(".bundle") || file.getName().endsWith(JsonFileUtils.METADATA_FILE_NAME_SUFFIX)) {
                DependentBundle dependentBundle = new DependentBundle(file);
                dependentBundles.add(dependentBundle);
                dependencySet.forEach(dependency -> {
                    if (file.getName().startsWith(dependency.getName() + "-" + dependency.getVersion())) {
                        dependentBundle.setGroupName(dependency.getGroup());
                        dependentBundle.setName(dependency.getName());
                        dependentBundle.setVersion(dependency.getVersion());
                        dependentBundle.setType("bundle");
                    }
                });
            }
        });
        return dependentBundles;
    }
}

