/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.properties;

import com.ca.apim.gateway.cagatewayexport.util.properties.OrderedProperties;
import com.ca.apim.gateway.cagatewayexport.util.properties.PropertyFileException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class PropertyFileUtils {
    @NotNull
    public static Properties loadExistingProperties(File propertiesFile) {
        OrderedProperties properties = new OrderedProperties();
        if (propertiesFile.exists()) {
            try (InputStream stream = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
                properties.load(stream);
            }
            catch (IOException e) {
                throw new PropertyFileException("Exception reading existing contents from " + propertiesFile.getName() + " file", e);
            }
        }
        return properties;
    }

    private PropertyFileUtils() {
    }
}

