/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.policy;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.ContextVariableEnvironmentProperty;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.LinkerException;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicyAssertionSimplifier;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicySimplifierContext;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicySimplifierUtils;
import javax.inject.Singleton;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.Element;

@Singleton
public class SetVariableAssertionSimplifier
implements PolicyAssertionSimplifier {
    @Override
    public void simplifyAssertionElement(PolicySimplifierContext context) throws DocumentParseException {
        Element element = context.getAssertionElement();
        Bundle resultantBundle = context.getResultantBundle();
        Element base64ExpressionElement = DocumentUtils.getSingleElement((Element)element, (String)"L7p:Base64Expression");
        String base64Expression = base64ExpressionElement.getAttribute("stringValue");
        byte[] decodedValue = PolicySimplifierUtils.base64Decode(base64Expression);
        Element variableToSetElement = DocumentUtils.getSingleElement((Element)element, (String)"L7p:VariableToSet");
        String variableName = variableToSetElement.getAttribute("stringValue");
        if (variableName.startsWith("ENV.")) {
            if (variableName.startsWith("ENV.gateway.")) {
                throw new LinkerException("Cannot have local environment property start with the prefix `ENV.gateway.`. Property: " + variableName);
            }
            ContextVariableEnvironmentProperty contextVarEnvironmentProperty = new ContextVariableEnvironmentProperty(BuilderUtils.insertPrefixToEnvironmentVariable((String)variableName, (String)context.getPolicyName()).substring(4), new String(decodedValue));
            ContextVariableEnvironmentProperty existingContextVarEnvironmentProperty = (ContextVariableEnvironmentProperty)resultantBundle.getEntities(ContextVariableEnvironmentProperty.class).get(contextVarEnvironmentProperty.getName());
            if (existingContextVarEnvironmentProperty != null) {
                throw new LinkerException("Found duplicate environment property: `" + variableName.substring(4) + "`. Cannot have multiple environment properties with the same name.");
            }
            resultantBundle.getEntities(ContextVariableEnvironmentProperty.class).put(contextVarEnvironmentProperty.getName(), contextVarEnvironmentProperty);
        } else {
            Element expressionElement = element.getOwnerDocument().createElement("L7p:Expression");
            String value = new String(decodedValue);
            expressionElement.appendChild(element.getOwnerDocument().createCDATASection(StringEscapeUtils.escapeXml11((String)value)));
            element.insertBefore(expressionElement, base64ExpressionElement);
        }
        element.removeChild(base64ExpressionElement);
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:SetVariable";
    }
}

