/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.policy;

import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class EncassPolicyXMLSimplifier {
    private static final Logger LOGGER = Logger.getLogger(EncassPolicyXMLSimplifier.class.getName());

    public String simplifyEncassPolicyXML(Policy policy) {
        Element encassPortalIntegrationElement = null;
        Element encassPortalIntegrationEnabledElement = null;
        try {
            encassPortalIntegrationElement = DocumentUtils.getSingleElement((Element)policy.getPolicyDocument(), (String)"L7p:ApiPortalEncassIntegration");
        }
        catch (DocumentParseException e) {
            LOGGER.log(Level.INFO, "ApiPortalEncassIntegration assertion is not found in encass policy : {0}, setting portalTemplate as false : ", policy.getName());
        }
        if (encassPortalIntegrationElement != null) {
            Element encassPortalIntegrationParentElement = (Element)encassPortalIntegrationElement.getParentNode();
            encassPortalIntegrationEnabledElement = DocumentUtils.getSingleChildElement((Element)encassPortalIntegrationElement, (String)"L7p:Enabled", (boolean)true);
            encassPortalIntegrationParentElement.removeChild(encassPortalIntegrationElement);
        }
        return encassPortalIntegrationElement != null && encassPortalIntegrationEnabledElement == null ? "true" : "false";
    }
}

