/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.policy;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.MissingGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicyAssertionSimplifier;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicySimplifierContext;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class EncapsulatedAssertionSimplifier
implements PolicyAssertionSimplifier {
    private static final Logger LOGGER = Logger.getLogger(EncapsulatedAssertionSimplifier.class.getName());

    @Override
    public void simplifyAssertionElement(PolicySimplifierContext context) throws DocumentParseException {
        Element encapsulatedAssertionElement = context.getAssertionElement();
        Bundle bundle = context.getBundle();
        Bundle resultantBundle = context.getResultantBundle();
        Element encassGuidElement = DocumentUtils.getSingleElement((Element)encapsulatedAssertionElement, (String)"L7p:EncapsulatedAssertionConfigGuid");
        String encassGuid = encassGuidElement.getAttribute("stringValue");
        Optional<Encass> resultantEncassEntity = resultantBundle.getEntities(Encass.class).values().stream().filter(e -> encassGuid.equals(e.getGuid())).findAny();
        if (resultantEncassEntity.isPresent()) {
            Optional<Policy> resultantPolicyEntity = resultantBundle.getPolicies().values().stream().filter(p -> ((Encass)resultantEncassEntity.get()).getPolicyId().equals(p.getId())).findFirst();
            if (resultantPolicyEntity.isPresent()) {
                encapsulatedAssertionElement.setAttribute("encassName", resultantEncassEntity.get().getName());
                Element encapsulatedAssertionConfigNameElement = DocumentUtils.getSingleChildElement((Element)encapsulatedAssertionElement, (String)"L7p:EncapsulatedAssertionConfigName", (boolean)true);
                if (encapsulatedAssertionConfigNameElement != null) {
                    encapsulatedAssertionElement.removeChild(encapsulatedAssertionConfigNameElement);
                }
                encapsulatedAssertionElement.removeChild(encassGuidElement);
            } else {
                Optional<Policy> policyEntity = bundle.getPolicies().values().stream().filter(p -> ((Encass)resultantEncassEntity.get()).getPolicyId().equals(p.getId())).findFirst();
                if (!policyEntity.isPresent()) {
                    LOGGER.log(Level.WARNING, "Could not find referenced encass policy with id: {0}", resultantEncassEntity.get().getPolicyId());
                }
                this.simplifyAssertionElementForMissingEntity(context, encapsulatedAssertionElement, policyEntity.isPresent());
            }
        } else {
            Optional<Encass> encassEntity = bundle.getEntities(Encass.class).values().stream().filter(e -> encassGuid.equals(e.getGuid())).findAny();
            if (!encassEntity.isPresent()) {
                LOGGER.log(Level.WARNING, "Could not find referenced encass with guid: {0}", encassGuid);
            }
            this.simplifyAssertionElementForMissingEntity(context, encapsulatedAssertionElement, encassEntity.isPresent());
        }
    }

    private void simplifyAssertionElementForMissingEntity(PolicySimplifierContext context, Element encassAssertionElement, boolean excluded) {
        Element encassGuidElement = DocumentUtils.getSingleChildElement((Element)encassAssertionElement, (String)"L7p:EncapsulatedAssertionConfigGuid");
        Element encassNameElement = DocumentUtils.getSingleChildElement((Element)encassAssertionElement, (String)"L7p:EncapsulatedAssertionConfigName", (boolean)true);
        MissingGatewayEntity missingEntity = new MissingGatewayEntity();
        missingEntity.setType("ENCAPSULATED_ASSERTION");
        missingEntity.setGuid(encassGuidElement.getAttribute("stringValue"));
        missingEntity.setName(encassNameElement != null ? encassNameElement.getAttribute("stringValue") : "Encass#" + missingEntity.getGuid());
        missingEntity.setId(missingEntity.getGuid().replace("-", ""));
        missingEntity.setExcluded(excluded);
        context.getResultantBundle().addEntity((GatewayEntity)missingEntity);
        encassAssertionElement.setAttribute("encassName", missingEntity.getName());
        encassAssertionElement.removeChild(encassGuidElement);
        if (encassNameElement != null) {
            encassAssertionElement.removeChild(encassNameElement);
        }
        LOGGER.log(Level.WARNING, "Recording the referenced encass with guid: {0} as missing entity", new Object[]{missingEntity.getGuid(), missingEntity.getName()});
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:Encapsulated";
    }
}

