/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.gateway;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Dependency;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityUtils;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.EntityFilterException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DependencyUtils {
    private DependencyUtils() {
    }

    @NotNull
    public static <E extends GatewayEntity> List<E> filterDependencies(Class<E> dependentEntityType, Bundle bundle, Bundle filteredBundle, Predicate<E> includeEntity) {
        Set<Dependency> dependentEntities = DependencyUtils.filterDependencies(dependentEntityType, bundle.getDependencyMap(), filteredBundle);
        return bundle.getEntities(dependentEntityType).values().stream().filter(entity -> dependentEntities.contains(new Dependency(entity.getId(), dependentEntityType, entity.getName(), EntityUtils.getEntityType((Class)dependentEntityType))) || includeEntity.test(entity)).collect(Collectors.toList());
    }

    private static <E extends GatewayEntity> Set<Dependency> filterDependencies(Class<E> dependentEntityType, Map<Dependency, List<Dependency>> dependencies, Bundle bundle) {
        return dependencies.entrySet().stream().filter(e -> bundle.getEntities(((Dependency)e.getKey()).getTypeClass()).get(((Dependency)e.getKey()).getId()) != null).flatMap(e -> ((List)e.getValue()).stream()).filter(d -> d.getTypeClass() == dependentEntityType).collect(Collectors.toSet());
    }

    public static <E extends GatewayEntity> void validateEntitiesInList(List<E> entities, Collection<String> entityNames, String entityName) {
        HashSet missingEntities = new HashSet();
        entityNames.forEach(name -> {
            if (entities.stream().noneMatch(c -> name.equals(c.getName()))) {
                missingEntities.add(name);
            }
        });
        if (!missingEntities.isEmpty()) {
            throw new EntityFilterException("Missing " + entityName + " with name: '" + String.join((CharSequence)"', '", missingEntities) + "'");
        }
    }
}

