/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.export;

import com.ca.apim.gateway.cagatewayconfig.util.connection.GatewayClient;
import com.ca.apim.gateway.cagatewayconfig.util.connection.GatewayClientException;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionRegistry;
import com.ca.apim.gateway.cagatewayexport.config.GatewayExportConnectionProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.RequestBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ExportTask
extends DefaultTask {
    private static final Logger LOGGER = Logger.getLogger(ExportTask.class.getName());
    private GatewayClient gatewayClient = (GatewayClient)InjectionRegistry.getInstance(GatewayClient.class);
    private GatewayExportConnectionProperties gatewayConnectionProperties = new GatewayExportConnectionProperties(this.getProject());
    private Property<String> exportQuery = this.getProject().getObjects().property(String.class);
    private RegularFileProperty exportFile = this.newOutputFile();

    public ExportTask() {
        this.getOutputs().upToDateWhen(t -> false);
    }

    @Nested
    public GatewayExportConnectionProperties getGatewayConnectionProperties() {
        return this.gatewayConnectionProperties;
    }

    public void setGatewayConnectionProperties(GatewayExportConnectionProperties gatewayConnectionProperties) {
        this.gatewayConnectionProperties = gatewayConnectionProperties;
    }

    @Input
    public Property<String> getExportQuery() {
        return this.exportQuery;
    }

    @OutputFile
    public RegularFileProperty getExportFile() {
        return this.exportFile;
    }

    void setGatewayClient(GatewayClient gatewayClient) {
        this.gatewayClient = gatewayClient;
    }

    @TaskAction
    public void perform() {
        LOGGER.log(Level.INFO, "Exporting with query: {0}", this.exportQuery.get());
        File destFile = (File)this.exportFile.getAsFile().get();
        try {
            FileUtils.copyInputStreamToFile((InputStream)this.gatewayClient.makeGatewayAPICall(RequestBuilder.create((String)"GET").setUri(GatewayClient.getRestmanBundleEndpoint((String)((String)this.gatewayConnectionProperties.getUrl().get())) + (String)this.exportQuery.get()), (String)this.gatewayConnectionProperties.getUserName().get(), (String)this.gatewayConnectionProperties.getUserPass().get()), (File)destFile);
        }
        catch (IOException e) {
            throw new GatewayClientException("Could not save response bundle from gateway into file " + destFile.getName(), (Throwable)e);
        }
    }
}

