/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.linker;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.JdbcConnection;
import com.ca.apim.gateway.cagatewayconfig.beans.StoredPassword;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.VariableUtils;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntityLinker;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.LinkerConstants;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.LinkerException;
import java.util.regex.Matcher;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class JdbcConnectionLinker
implements EntityLinker<JdbcConnection> {
    @Override
    public void link(JdbcConnection entity, Bundle bundle, Bundle targetBundle) {
        if (entity.getPassword() != null) {
            if (entity.getPassword().startsWith("$L7C2$")) {
                entity.setPassword(null);
            } else {
                Matcher matcher;
                String storedPasswordReference = VariableUtils.extractVariableName((String)entity.getPassword());
                if (!StringUtils.isEmpty((CharSequence)storedPasswordReference) && (matcher = LinkerConstants.STORED_PASSWORD_PATTERN.matcher(storedPasswordReference)).matches()) {
                    String storedPasswordName = matcher.group(1);
                    this.setPasswordRef(entity, bundle, storedPasswordName);
                }
            }
        }
    }

    private void setPasswordRef(JdbcConnection entity, Bundle bundle, String storedPasswordName) {
        StoredPassword storedPassword = bundle.getEntities(StoredPassword.class).values().stream().filter(e -> e.getName().equals(storedPasswordName)).findFirst().orElse(null);
        if (storedPassword == null) {
            throw new LinkerException("Could not find Stored Password for JDBC Connection: " + entity.getName() + ". Password Name: " + storedPasswordName);
        }
        entity.setPasswordRef(storedPassword.getName());
        entity.setPassword(null);
    }

    @Override
    public Class<JdbcConnection> getEntityClass() {
        return JdbcConnection.class;
    }
}

