/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.linker;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntityLinker;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.LinkerException;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.PolicyLinker;
import com.ca.apim.gateway.cagatewayexport.util.policy.EncassPolicyXMLSimplifier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EncassLinker
implements EntityLinker<Encass> {
    private final EncassPolicyXMLSimplifier encassPolicyXMLSimplifier;

    @Inject
    EncassLinker(EncassPolicyXMLSimplifier encassPolicyXMLSimplifier) {
        this.encassPolicyXMLSimplifier = encassPolicyXMLSimplifier;
    }

    @Override
    public Class<Encass> getEntityClass() {
        return Encass.class;
    }

    @Override
    public void link(Encass encass, Bundle bundle, Bundle targetBundle) {
        Policy policy = bundle.getPolicies().values().stream().filter(p -> encass.getPolicyId().equals(p.getId())).findFirst().orElse(null);
        if (policy == null) {
            throw new LinkerException("Could not find policy for Encapsulated Assertion: " + encass.getName() + ". Policy ID: " + encass.getPolicyId());
        }
        encass.getProperties().put("l7Template", this.encassPolicyXMLSimplifier.simplifyEncassPolicyXML(policy));
        encass.setPolicy(policy.getPath());
        encass.setPath(PolicyLinker.getPolicyPath(policy, bundle, encass));
    }
}

