/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.filter;

import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.EntityFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EntityFilterRegistry {
    private final Collection<EntityFilter> entityFilters;

    @Inject
    public EntityFilterRegistry(Set<EntityFilter> entityFilters) {
        LinkedHashMap<String, EntityFilter> sortedFilters = new LinkedHashMap<String, EntityFilter>();
        for (EntityFilter entityFilter : entityFilters) {
            this.addFilterWithDependencies(entityFilter.getClass(), sortedFilters);
            sortedFilters.put(entityFilter.getClass().getName(), entityFilter);
        }
        this.entityFilters = Collections.unmodifiableCollection(sortedFilters.values());
    }

    private void addFilterWithDependencies(Class<? extends EntityFilter> entityFilter, Map<String, EntityFilter> sortedFilters) {
        Collection<Class<? extends EntityFilter>> dependentFilters = this.getDependentFilters(entityFilter);
        if (dependentFilters.isEmpty()) {
            sortedFilters.putIfAbsent(entityFilter.getName(), null);
        } else {
            for (Class<? extends EntityFilter> dependentFilter : dependentFilters) {
                if (sortedFilters.containsKey(dependentFilter.getName())) continue;
                this.addFilterWithDependencies(dependentFilter, sortedFilters);
            }
            sortedFilters.putIfAbsent(entityFilter.getName(), null);
        }
    }

    private Collection<Class<? extends EntityFilter>> getDependentFilters(Class<? extends EntityFilter> entityFilterClass) {
        EntityFilter entityFilter = EntityFilter.getEntityFilterFromClass(entityFilterClass);
        return entityFilter.getDependencyEntityFilters();
    }

    public Collection<EntityFilter> getEntityFilters() {
        return this.entityFilters;
    }
}

