/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode;

import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionRegistry;
import com.ca.apim.gateway.cagatewayconfig.util.json.JsonTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.ExplodeBundle;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.FilterConfiguration;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class ExplodeBundleTask
extends DefaultTask {
    private Property<String> folderPath = this.getProject().getObjects().property(String.class);
    private RegularFileProperty inputBundleFile = this.newInputFile();
    private DirectoryProperty exportDir = this.newOutputDirectory();
    private final Property<Map> exportEntities = this.getProject().getObjects().property(Map.class);

    @Inject
    public ExplodeBundleTask() {
        JsonTools.INSTANCE.setOutputType("yaml");
        this.getOutputs().upToDateWhen(t -> false);
    }

    @Input
    @Optional
    public Property<String> getFolderPath() {
        return this.folderPath;
    }

    @InputFile
    public RegularFileProperty getInputBundleFile() {
        return this.inputBundleFile;
    }

    @OutputDirectory
    public DirectoryProperty getExportDir() {
        return this.exportDir;
    }

    @Option(option="outputType", description="The output type of the configuration files. Either 'yaml' or 'json'.")
    public void setOutputType(String format) {
        JsonTools.INSTANCE.setOutputType(format);
    }

    @Input
    @Optional
    public Property<Map> getExportEntities() {
        return this.exportEntities;
    }

    @TaskAction
    public void perform() throws DocumentParseException {
        ExplodeBundle explodeBundle = (ExplodeBundle)InjectionRegistry.getInstance(ExplodeBundle.class);
        this.checkExportEntities();
        explodeBundle.explodeBundle((String)this.folderPath.getOrElse((Object)"/"), this.toFilterConfiguration((Map)this.exportEntities.getOrElse(Collections.emptyMap())), (File)this.inputBundleFile.getAsFile().get(), (File)this.exportDir.getAsFile().get());
    }

    private void checkExportEntities() {
        if (this.exportEntities.isPresent()) {
            ((Map)this.exportEntities.get()).forEach((k, v) -> {
                if (!String.class.isAssignableFrom(k.getClass())) {
                    throw new IllegalArgumentException("Expected exportEntities map keys to all be Strings. Found type: '" + k.getClass() + "' for key: " + k);
                }
                if (!Collection.class.isAssignableFrom(v.getClass())) {
                    throw new IllegalArgumentException("Expected exportEntities map values to all be Collections of Strings. Found type: '" + v.getClass() + "' for key: " + k);
                }
                ((Collection)v).forEach(s -> {
                    if (!String.class.isAssignableFrom(s.getClass())) {
                        throw new IllegalArgumentException("Expected exportEntities map values to all be Collections of Strings. Found type: '" + s.getClass() + "' in collection for key: '" + k + "'. It's value is: " + s);
                    }
                });
            });
        }
    }

    private FilterConfiguration toFilterConfiguration(Map<String, Collection<String>> gatewayExportEntities) {
        FilterConfiguration filterConfiguration = new FilterConfiguration();
        filterConfiguration.setEntityFilters(gatewayExportEntities);
        return filterConfiguration;
    }
}

