/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport;

import com.ca.apim.gateway.cagatewayexport.CAGatewayExportBase;
import com.ca.apim.gateway.cagatewayexport.config.GatewayExportConnectionProperties;
import com.ca.apim.gateway.cagatewayexport.config.GatewayExportPluginConfig;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.ExplodeBundleTask;
import com.ca.apim.gateway.cagatewayexport.tasks.export.BuildExportQueryTask;
import com.ca.apim.gateway.cagatewayexport.tasks.export.ExportTask;
import com.ca.apim.gateway.cagatewayexport.tasks.sanitize.SanitizeBundleTask;
import java.io.File;
import java.util.function.Supplier;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Delete;
import org.jetbrains.annotations.NotNull;

public class CAGatewayExport
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        project.getPlugins().apply(CAGatewayExportBase.class);
        project.getPlugins().apply("base");
        GatewayExportPluginConfig pluginConfig = (GatewayExportPluginConfig)project.getExtensions().create("GatewayExportConfig", GatewayExportPluginConfig.class, new Object[]{project});
        project.afterEvaluate(p -> this.setDefaults(pluginConfig, project));
        GatewayExportConnectionProperties gatewayConnectionProperties = (GatewayExportConnectionProperties)project.getExtensions().create("GatewayConnection", GatewayExportConnectionProperties.class, new Object[]{project});
        project.afterEvaluate(p -> CAGatewayExport.setDefaults(gatewayConnectionProperties));
        BuildExportQueryTask buildExportQueryTask = (BuildExportQueryTask)project.getTasks().create("build-export-query", BuildExportQueryTask.class);
        ExportTask exportTask = (ExportTask)project.getTasks().create("export-raw", ExportTask.class, t -> {
            t.setGatewayConnectionProperties(gatewayConnectionProperties);
            t.getExportFile().set((Provider)pluginConfig.getRawBundle());
            t.getExportQuery().set(buildExportQueryTask.getExportQuery());
        });
        exportTask.dependsOn(new Object[]{buildExportQueryTask});
        SanitizeBundleTask sanitizeTask = (SanitizeBundleTask)project.getTasks().create("sanitize-export", SanitizeBundleTask.class, sanitizeBundleTask -> {
            sanitizeBundleTask.getInputBundleFile().set((Provider)pluginConfig.getRawBundle());
            sanitizeBundleTask.getOutputBundleFile().set((Provider)pluginConfig.getSanitizedBundle());
        });
        sanitizeTask.dependsOn(new Object[]{exportTask});
        ExplodeBundleTask explodeBundleTask = (ExplodeBundleTask)project.getTasks().create("export", ExplodeBundleTask.class, t -> {
            t.getFolderPath().set(pluginConfig.getFolderPath());
            t.getInputBundleFile().set((Provider)pluginConfig.getSanitizedBundle());
            t.getExportDir().set((Provider)pluginConfig.getSolutionDir());
            t.getExportEntities().set(pluginConfig.getExportEntities());
        });
        explodeBundleTask.dependsOn(new Object[]{sanitizeTask});
        project.getTasks().create("clean-export", Delete.class, t -> t.delete(new Object[]{pluginConfig.getSolutionDir()}));
    }

    private void setDefaults(GatewayExportPluginConfig pluginConfig, @NotNull Project project) {
        if (!pluginConfig.getSolutionDir().isPresent()) {
            pluginConfig.getSolutionDir().set(new File(project.getProjectDir(), "src/main/gateway"));
        }
        if (!pluginConfig.getRawBundle().isPresent()) {
            pluginConfig.getRawBundle().set(new File(new File(project.getBuildDir(), "gateway"), project.getName() + ".raw.bundle"));
        }
        if (!pluginConfig.getSanitizedBundle().isPresent()) {
            pluginConfig.getSanitizedBundle().set(new File(new File(project.getBuildDir(), "gateway"), project.getName() + ".sanitized.bundle"));
        }
    }

    private static void setDefaults(GatewayExportConnectionProperties gatewayConnectionProperties) {
        CAGatewayExport.setDefault(gatewayConnectionProperties.getUrl(), () -> "https://localhost:8443/restman");
        CAGatewayExport.setDefault(gatewayConnectionProperties.getUserName(), () -> "admin");
        CAGatewayExport.setDefault(gatewayConnectionProperties.getUserPass(), () -> "password");
    }

    private static <T> void setDefault(Property<T> property, Supplier<T> supplier) {
        if (!property.isPresent()) {
            property.set(supplier.get());
        }
    }
}

