/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.injection;

import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionConfigurationException;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionProvider;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionProviderContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class InjectionRegistry
extends AbstractModule {
    private static final InjectionRegistry INSTANCE = new InjectionRegistry();
    private static final String INJECTION_BASE_PACKAGE_KEY = "injection.base.package";
    private static Injector injector;

    private InjectionRegistry() {
    }

    protected void configure() {
        HashMap<Class, Object> singleInstances = new HashMap<Class, Object>();
        HashMap<Class, Set> multibindings = new HashMap<Class, Set>();
        InjectionRegistry.findPackagesToScan().forEach(p -> {
            Reflections refl = new Reflections(p, new Scanner[0]);
            InjectionProviderContext context = new InjectionProviderContext(refl);
            refl.getSubTypesOf(InjectionProvider.class).forEach(c -> {
                InjectionProvider provider = InjectionRegistry.instantiateProvider(c);
                this.bind(Reflections.class).annotatedWith((Annotation)Names.named((String)("Reflections_" + provider.getClass().getSimpleName()))).toInstance((Object)refl);
                Optional.ofNullable(provider.getSingleBindings(context)).orElse(Collections.emptyList()).forEach(arg_0 -> ((InjectionRegistry)this).bind(arg_0));
                Optional.ofNullable(provider.getSingleInstances(context)).orElse(Collections.emptyMap()).forEach((clazz, object) -> {
                    Object oldValue = singleInstances.put((Class)clazz, object);
                    if (oldValue != null) {
                        throw new InjectionConfigurationException("Found more than one instance of " + clazz);
                    }
                });
                Optional.ofNullable(provider.getMultiBindings(context)).orElse(Collections.emptyMap()).forEach((baseClass, subClasses) -> {
                    Set bindings = multibindings.computeIfAbsent((Class)baseClass, clazz -> new HashSet());
                    subClasses.stream().filter(l -> !Modifier.isAbstract(l.getModifiers()) && !Modifier.isInterface(l.getModifiers()) && l.getEnclosingClass() == null).forEach(bindings::add);
                });
            });
        });
        singleInstances.forEach((clazz, object) -> this.bind((Class)clazz).toInstance(object));
        multibindings.forEach((baseClass, subClasses) -> {
            Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), (Class)baseClass);
            subClasses.forEach(c -> multibinder.addBinding().to(c));
        });
    }

    private static Set<String> findPackagesToScan() {
        HashSet<String> packagesToScan = new HashSet<String>();
        try {
            Enumeration<URL> resources = InjectionRegistry.class.getClassLoader().getResources("gateway-developer-plugin-extension.properties");
            while (resources.hasMoreElements()) {
                Properties properties = new Properties();
                properties.load(resources.nextElement().openStream());
                if (!properties.containsKey(INJECTION_BASE_PACKAGE_KEY)) continue;
                packagesToScan.add(properties.getProperty(INJECTION_BASE_PACKAGE_KEY));
            }
        }
        catch (IOException e) {
            throw new InjectionConfigurationException("Could not load plugin configuration files: " + e.getMessage(), e);
        }
        return packagesToScan;
    }

    private static InjectionProvider instantiateProvider(Class<? extends InjectionProvider> providerClass) {
        Constructor<? extends InjectionProvider> constructor;
        try {
            constructor = providerClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InjectionConfigurationException("No empty constructor available for class " + providerClass.getName(), e);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new InjectionConfigurationException("Error instantiating provider for class " + providerClass.getName() + ": " + e.getMessage(), e);
        }
    }

    public static Injector getInjector() {
        return Optional.ofNullable(injector).orElseGet(InjectionRegistry::create);
    }

    public static <T> T getInstance(Class<T> serviceClass) {
        return (T)InjectionRegistry.getInjector().getInstance(serviceClass);
    }

    @VisibleForTesting
    static Injector create() {
        injector = Guice.createInjector((Module[])new Module[]{INSTANCE});
        return injector;
    }
}

