/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.file;

import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtilsException;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.w3c.dom.Element;

public class DocumentFileUtils {
    public static final DocumentFileUtils INSTANCE = new DocumentFileUtils(DocumentTools.INSTANCE);
    private final DocumentTools documentTools;
    public static final String BUNDLE_EXTENSION = ".bundle";
    public static final String DELETE_BUNDLE_EXTENSION = ".delete.bundle";
    public static final String INSTALL_BUNDLE_EXTENSION = ".install.bundle";
    public static final String PREFIX_ENVIRONMENT = "environment";
    public static final String PREFIX_FULL = "-full";

    private DocumentFileUtils(DocumentTools documentTools) {
        this.documentTools = documentTools;
    }

    public void createFile(Element element, Path path) {
        this.createFile(element, path, false);
    }

    public void createFile(Element element, Path path, boolean addNamespace) {
        OutputStream fos = null;
        try {
            fos = Files.newOutputStream(path, new OpenOption[0]);
            this.documentTools.printXML(element, fos, addNamespace);
        }
        catch (IOException e) {
            try {
                throw new DocumentFileUtilsException("Error writing to file '" + path + "': " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(fos);
    }

    public synchronized void createFolder(Path folderPath) {
        if (!folderPath.toFile().exists()) {
            try {
                Files.createDirectory(folderPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DocumentFileUtilsException("Exception creating folder: " + folderPath, e);
            }
        } else if (!folderPath.toFile().isDirectory()) {
            throw new DocumentFileUtilsException("Wanted to create folder but found a file: " + folderPath);
        }
    }

    public synchronized void createFolders(Path folderPath) {
        if (!folderPath.toFile().exists()) {
            try {
                Files.createDirectories(folderPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DocumentFileUtilsException("Exception creating folder(s): " + folderPath, e);
            }
        } else if (!folderPath.toFile().isDirectory()) {
            throw new DocumentFileUtilsException("Wanted to create folder but found a file: " + folderPath);
        }
    }
}

