/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class IdGenerator {
    private AtomicLong hi;
    private AtomicLong low;
    private static final int MAX_ID_RESERVED_PREFIX = 65536;
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public IdGenerator() {
        long randomHi;
        SecureRandom random = new SecureRandom();
        while ((randomHi = random.nextLong()) >= 0L && randomHi < 65536L) {
        }
        this.hi = new AtomicLong(randomHi);
        this.low = new AtomicLong(random.nextLong());
    }

    public String generate() {
        return IdGenerator.hexDump(ByteBuffer.allocate(16).putLong(this.hi.get()).putLong(this.low.getAndIncrement()).array());
    }

    private static String hexDump(byte[] binaryData) {
        return IdGenerator.hexDump(binaryData, binaryData.length);
    }

    private static String hexDump(byte[] binaryData, int len) {
        int off = 0;
        if (binaryData == null) {
            throw new NullPointerException();
        }
        if (len < 0 || off + len > binaryData.length) {
            throw new IllegalArgumentException();
        }
        char[] buffer = new char[len * 2];
        for (int i = 0; i < len; ++i) {
            int low = binaryData[off + i] & 0xF;
            int high = (binaryData[off + i] & 0xF0) >> 4;
            buffer[i * 2] = hexadecimal[high];
            buffer[i * 2 + 1] = hexadecimal[low];
        }
        return new String(buffer);
    }

    public String generateGuid() {
        return UUID.randomUUID().toString();
    }
}

