/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader.policy;

import com.ca.apim.gateway.cagatewayconfig.config.loader.policy.PolicyConverter;
import com.ca.apim.gateway.cagatewayconfig.config.loader.policy.PolicyConverterException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Singleton
public class PolicyConverterRegistry {
    private final Set<PolicyConverter> policyConverters;
    private static final Logger LOGGER = Logger.getLogger(PolicyConverterRegistry.class.getName());

    @Inject
    public PolicyConverterRegistry(Set<PolicyConverter> converters) {
        this.policyConverters = Collections.unmodifiableSet(converters);
    }

    @NotNull
    public boolean isValidPolicyExtension(String fileName) {
        boolean isValidPolicyExtension = this.policyConverters.stream().anyMatch(converter -> fileName.endsWith(converter.getPolicyTypeExtension()));
        if (!isValidPolicyExtension) {
            LOGGER.log(Level.WARNING, "Unknown policy file extension for file: {0}", fileName);
        }
        return isValidPolicyExtension;
    }

    @NotNull
    public PolicyConverter getConverterFromFileName(String fileName) {
        return this.policyConverters.stream().filter(converter -> fileName.endsWith(converter.getPolicyTypeExtension())).findFirst().orElseThrow(() -> new PolicyConverterException("Unknown policy file extension for file: " + fileName));
    }

    @NotNull
    public PolicyConverter getFromPolicyElement(String name, Element policy) {
        return this.policyConverters.stream().filter(converter -> converter.canConvert(name, policy)).findFirst().orElseGet(() -> this.getConverterFromFileName(".xml"));
    }
}

